/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.cdi;

import ascelion.cdi.literal.AnyLiteral;
import ascelion.cdi.metadata.AnnotatedTypeModifier;
import ascelion.flyway.api.FlywayMigration;
import ascelion.flyway.cdi.CdiInstance;
import ascelion.flyway.cdi.CdiMigrationResolver;
import ascelion.flyway.cdi.Graph;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlywayCdiExtension
implements Extension {
    private static final Logger L = LoggerFactory.getLogger(FlywayCdiExtension.class);

    static Optional<FlywayMigration> flywayMigrationAnnotation(Bean<?> bean) {
        return bean.getQualifiers().stream().filter(q -> q.annotationType() == FlywayMigration.class).map(FlywayMigration.class::cast).findAny();
    }

    void beforeBeanDiscovery(BeanManager bm, @Observes BeforeBeanDiscovery event) {
        AnnotatedType at = bm.createAnnotatedType(FlywayMigration.class);
        AnnotatedTypeModifier atm = AnnotatedTypeModifier.create((AnnotatedType)at);
        L.info("Adding qualifier {}", FlywayMigration.class);
        event.addQualifier(atm.makeQualifier(new String[]{"value"}));
    }

    void afterTypeDiscovery(BeanManager bm, @Observes AfterTypeDiscovery event) {
        this.registerType(bm, event, Configuration.class);
        this.registerType(bm, event, CdiMigrationResolver.class);
    }

    void afterDeploymentValidation(BeanManager bm, @Observes AfterDeploymentValidation event) {
        Set beans = bm.getBeans(Configuration.class, new Annotation[]{AnyLiteral.INSTANCE});
        switch (beans.size()) {
            case 0: {
                break;
            }
            case 1: {
                Bean bean = (Bean)beans.iterator().next();
                this.migrate(bm, (Bean<Configuration>)bean, FlywayCdiExtension.flywayMigrationAnnotation(bean).orElse(null));
                break;
            }
            default: {
                Graph graph = new Graph();
                beans.stream().map(CfBeanInfo::create).forEach(graph::add);
                graph.sort().forEach(v -> this.migrate(bm, (Bean<Configuration>)((CfBeanInfo)v).bean, ((CfBeanInfo)v).annotation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate(BeanManager bm, Bean<Configuration> bean, FlywayMigration fm) {
        CdiInstance<Configuration> cfi = new CdiInstance<Configuration>(bm, bean);
        CdiMigrationResolver res = new CdiMigrationResolver(bm, fm);
        try {
            List<MigrationResolver> resolvers = Arrays.stream(cfi.get().getResolvers()).collect(Collectors.toList());
            resolvers.add(res);
            this.addCSV(resolvers);
            FluentConfiguration cfg = Flyway.configure((ClassLoader)Thread.currentThread().getContextClassLoader()).configuration(cfi.get()).resolvers(resolvers.toArray(new MigrationResolver[0]));
            Flyway fw = new Flyway((Configuration)cfg);
            fw.migrate();
        }
        finally {
            cfi.destroy();
        }
    }

    private void registerType(BeanManager bm, AfterTypeDiscovery event, Class<?> cls) {
        String name = cls.getName();
        AnnotatedType type = bm.createAnnotatedType(cls);
        L.info("Adding type {}", (Object)name);
        event.addAnnotatedType(type, name);
    }

    private void addCSV(List<MigrationResolver> resolvers) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass("ascelion.flyway.csv.CSVMigrationResolver");
            resolvers.add((MigrationResolver)cls.newInstance());
        }
        catch (ClassNotFoundException | NoClassDefFoundError cls) {
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static class CfBeanInfo
    extends Graph.Vertex<String> {
        private final Bean<Configuration> bean;
        private final FlywayMigration annotation;

        static CfBeanInfo create(Bean<?> bean) {
            return new CfBeanInfo(bean, FlywayCdiExtension.flywayMigrationAnnotation(bean).get());
        }

        private CfBeanInfo(Bean<?> bean, FlywayMigration annotation) {
            super(annotation.name(), annotation.dependsOn());
            this.bean = bean;
            this.annotation = annotation;
        }
    }
}

