/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.cdi;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;

final class Graph<T, V extends Vertex<T>> {
    private final Map<T, V> vertices = new HashMap<T, V>();

    Graph() {
    }

    void add(V vertex) {
        this.vertices.compute(((Vertex)vertex).name, (k, v) -> {
            if (v != null) {
                throw new IllegalArgumentException("Vertex already present" + k);
            }
            return vertex;
        });
    }

    Collection<V> sort() {
        LinkedList sorted = new LinkedList();
        LinkedList cycle = new LinkedList();
        IdentityHashMap visited = new IdentityHashMap();
        for (Vertex v : this.vertices.values()) {
            this.visit(v, visited, sorted, cycle);
        }
        return Collections.unmodifiableCollection(sorted);
    }

    private void visit(V v, Map<V, Boolean> visited, Deque<V> stack, Deque<V> cycle) {
        if (cycle.contains(v)) {
            cycle.push(v);
            throw new CycleException(cycle);
        }
        cycle.push(v);
        if (visited.get(v) == null) {
            visited.put((Boolean)v, true);
            Arrays.stream(((Vertex)v).dependencies).map(this::lookup).forEach(dep -> this.visit(dep, visited, stack, cycle));
            stack.push(v);
        }
        cycle.pop();
    }

    private V lookup(T name) {
        Vertex v = (Vertex)this.vertices.get(name);
        if (v == null) {
            throw new LookupException(name);
        }
        return (V)v;
    }

    static class Vertex<D> {
        final D name;
        final D[] dependencies;

        Vertex(D name, D ... dependencies) {
            this.name = name;
            this.dependencies = dependencies;
        }

        public String toString() {
            return this.name.toString();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            D this$name = this.name;
            D other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Vertex;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            D $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }

    static class LookupException
    extends RuntimeException {
        private final Object name;

        <T> T name() {
            return (T)this.name;
        }

        @ConstructorProperties(value={"name"})
        @Generated
        LookupException(Object name) {
            this.name = name;
        }
    }

    static class CycleException
    extends RuntimeException {
        private final Collection<?> cycle;

        <V> Collection<V> cycle() {
            return this.cycle;
        }

        @ConstructorProperties(value={"cycle"})
        @Generated
        CycleException(Collection<?> cycle) {
            this.cycle = cycle;
        }
    }
}

