/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.csv;

import ascelion.flyway.csv.CSVMigrationExecutor;
import ascelion.flyway.csv.LineProvider;
import ascelion.flyway.csv.StatementBuilder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resource.Resource;

public abstract class CSVResolvedMigrationBase<R extends Resource>
implements ResolvedMigration {
    private final Map<String, List<String>> references;
    private final R resource;
    private final MigrationVersion version;
    private final String table;
    private final String description;
    private final int checksum;
    private final CSVMigrationExecutor executor;

    CSVResolvedMigrationBase(Map<String, List<String>> references, R resource, MigrationVersion version, String table, String description, int checksum) {
        this.references = references;
        this.resource = resource;
        this.version = version;
        this.table = table;
        this.description = description;
        this.checksum = checksum;
        this.executor = new CSVMigrationExecutor(this);
    }

    public final String getScript() {
        return this.resource.getRelativePath();
    }

    public final Integer getChecksum() {
        return this.checksum;
    }

    public final MigrationType getType() {
        return MigrationType.JDBC;
    }

    public final String getPhysicalLocation() {
        return this.resource.getAbsolutePathOnDisk();
    }

    void executBatch(Connection connection) throws SQLException, IOException {
        Statement batch = this.createBatch(connection);
        batch.executeBatch();
        ArrayList<String> keys = new ArrayList<String>();
        ResultSet rs = batch.getGeneratedKeys();
        while (rs.next()) {
            keys.add(rs.getObject(1).toString());
        }
        this.references.put(this.table, keys);
    }

    protected abstract LineProvider openResource() throws IOException;

    private Statement createBatch(Connection db) throws SQLException, IOException {
        try (LineProvider rd = this.openResource();){
            StatementBuilder sb = new StatementBuilder(db, this.table, rd, this.references);
            Statement statement = sb.createBatch(this.resource.getRelativePath());
            return statement;
        }
    }

    @Generated
    public R getResource() {
        return this.resource;
    }

    @Generated
    public MigrationVersion getVersion() {
        return this.version;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public CSVMigrationExecutor getExecutor() {
        return this.executor;
    }
}

