/*
 * Decompiled with CFR 0.152.
 */
package ascelion.flyway.cdi;

import ascelion.cdi.metadata.AnnotatedTypeModifier;
import ascelion.flyway.api.FlywayMigration;
import ascelion.flyway.cdi.CdiMigrationResolver;
import ascelion.flyway.cdi.Graph;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.AnnotationLiteral;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlywayCdiExtension
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(FlywayCdiExtension.class);
    private final Map<String, SortedSet<ConfigurationInstance>> migrations = new HashMap<String, SortedSet<ConfigurationInstance>>();

    private static <A extends Annotation> Optional<A> findMetaAnnotation(Class<A> type, Set<Annotation> visited, Collection<Annotation> annotations) {
        for (Annotation a : annotations) {
            Class<? extends Annotation> t;
            Optional result;
            if (!visited.add(a) || !(result = Optional.ofNullable((t = a.annotationType()).getAnnotation(type)).map(Optional::of).orElseGet(() -> FlywayCdiExtension.findMetaAnnotation(type, visited, Arrays.asList(t.getAnnotations())))).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    static <A extends Annotation> Optional<A> findMetaAnnotation(Class<A> type, Annotated annotated) {
        return Optional.ofNullable(annotated.getAnnotation(type)).map(Optional::of).orElseGet(() -> FlywayCdiExtension.findMetaAnnotation(type, new HashSet<Annotation>(), annotated.getAnnotations()));
    }

    void beforeBeanDiscovery(BeanManager bm, @Observes BeforeBeanDiscovery event) {
        AnnotatedType at = bm.createAnnotatedType(FlywayMigration.class);
        LOG.info("Adding qualifier {}", FlywayMigration.class);
        event.addQualifier(AnnotatedTypeModifier.makeQualifier((AnnotatedType)at, (String[])new String[]{"value"}));
        this.registerType(bm, event, Configuration.class);
        this.registerType(bm, event, CdiMigrationResolver.class);
    }

    private void registerType(BeanManager bm, BeforeBeanDiscovery event, Class<?> cls) {
        String name = cls.getName();
        AnnotatedType type = bm.createAnnotatedType(cls);
        LOG.info("Adding type {}", (Object)name);
        event.addAnnotatedType(type, name);
    }

    void processProducer(BeanManager bm, @Observes ProcessProducer<?, Configuration> event) {
        this.processConfiguration((Annotated)event.getAnnotatedMember(), (a, p) -> new ProducerInstance((Producer<Configuration>)event.getProducer(), (FlywayMigration)a, (Integer)p));
    }

    void processBean(BeanManager bm, @Observes ProcessBean<Configuration> event) {
        this.processConfiguration(event.getAnnotated(), (a, p) -> new BeanInstance((Bean<Configuration>)event.getBean(), (FlywayMigration)a, (Integer)p));
    }

    private void processConfiguration(Annotated annotated, BiFunction<FlywayMigration, Integer, ConfigurationInstance> sup) {
        FlywayMigration annotation = FlywayCdiExtension.findMetaAnnotation(FlywayMigration.class, annotated).orElseGet(NoFlywayMigration::new);
        boolean alternative = FlywayCdiExtension.findMetaAnnotation(Alternative.class, annotated).map(a -> true).orElse(false);
        Integer priority = FlywayCdiExtension.findMetaAnnotation(Priority.class, annotated).map(Priority::value).orElseGet(() -> alternative ? Integer.valueOf(0) : null);
        LOG.info("Found migration {}, alternative: {}, priority: {}", new Object[]{annotation.name(), alternative, priority});
        this.migrations.computeIfAbsent(annotation.name(), k -> new TreeSet()).add(sup.apply(annotation, priority));
    }

    void afterDeploymentValidation(BeanManager bm, @Observes AfterDeploymentValidation event) {
        Graph graph = new Graph();
        this.migrations.values().stream().map(s -> (ConfigurationInstance)s.first()).forEach(i -> graph.add(new ConfigurationInfo((ConfigurationInstance)i)));
        graph.sort().forEach(mi -> this.migrate(bm, (ConfigurationInfo)mi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate(BeanManager bm, ConfigurationInfo ci) {
        CdiMigrationResolver res = new CdiMigrationResolver(bm, ci.instance.annotation);
        Configuration cfg = ci.instance.create(bm);
        try {
            List<MigrationResolver> resolvers = Arrays.stream(cfg.getResolvers()).collect(Collectors.toList());
            resolvers.add(res);
            this.addCSV(resolvers);
            FluentConfiguration newCfg = Flyway.configure((ClassLoader)Thread.currentThread().getContextClassLoader()).configuration(cfg).resolvers(resolvers.toArray(new MigrationResolver[0]));
            Flyway fw = new Flyway((Configuration)newCfg);
            LOG.info("Running migration {}", ci.name);
            fw.migrate();
        }
        finally {
            ci.instance.destroy(cfg);
        }
    }

    private void addCSV(List<MigrationResolver> resolvers) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass("ascelion.flyway.csv.CSVMigrationResolver");
            resolvers.add((MigrationResolver)cls.newInstance());
        }
        catch (ClassNotFoundException | NoClassDefFoundError cls) {
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static final class ConfigurationInfo
    extends Graph.Vertex<String> {
        final ConfigurationInstance instance;

        ConfigurationInfo(ConfigurationInstance instance) {
            super(instance.annotation.name(), instance.annotation.dependsOn());
            this.instance = instance;
        }
    }

    static class ProducerInstance
    extends ConfigurationInstance {
        final Producer<Configuration> prod;

        ProducerInstance(Producer<Configuration> prod, FlywayMigration annotation, Integer priority) {
            super(annotation, priority);
            this.prod = prod;
        }

        @Override
        Configuration create(BeanManager bm) {
            return (Configuration)this.prod.produce(bm.createCreationalContext(null));
        }

        @Override
        void destroy(Configuration instance) {
            this.prod.dispose((Object)instance);
        }
    }

    static class BeanInstance
    extends ConfigurationInstance {
        final Bean<Configuration> bean;
        CreationalContext<Configuration> context;

        BeanInstance(Bean<Configuration> bean, FlywayMigration annotation, Integer priority) {
            super(annotation, priority);
            this.bean = bean;
        }

        @Override
        Configuration create(BeanManager bm) {
            this.context = bm.createCreationalContext(this.bean);
            return (Configuration)this.bean.create(this.context);
        }

        @Override
        void destroy(Configuration instance) {
            this.bean.destroy((Object)instance, this.context);
        }
    }

    static abstract class ConfigurationInstance
    implements Comparable<ConfigurationInstance> {
        final FlywayMigration annotation;
        final Integer priority;

        abstract Configuration create(BeanManager var1);

        abstract void destroy(Configuration var1);

        @Override
        public int compareTo(ConfigurationInstance that) {
            if (this.priority != null && that.priority != null) {
                return -Integer.compare(this.priority, that.priority);
            }
            if (this.priority == null) {
                return 1;
            }
            if (that.priority == null) {
                return -1;
            }
            return 0;
        }

        @ConstructorProperties(value={"annotation", "priority"})
        @Generated
        public ConfigurationInstance(FlywayMigration annotation, Integer priority) {
            this.annotation = annotation;
            this.priority = priority;
        }
    }

    static class NoFlywayMigration
    extends AnnotationLiteral<FlywayMigration>
    implements FlywayMigration {
        NoFlywayMigration() {
        }

        public String name() {
            return "";
        }

        public String[] packages() {
            return new String[0];
        }

        public Class<?>[] packageClasses() {
            return new Class[0];
        }

        public String[] dependsOn() {
            return new String[0];
        }
    }
}

