/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.spi;

import ascelion.config.api.ConfigNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public final class Utils {
    private static final Pattern ARRAY_INDEX = Pattern.compile("^\\[\\d+\\]$");

    public static String[] pathElements(@NonNull String path) {
        int pos;
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        int size = path.length();
        if (size == 0) {
            throw new IllegalArgumentException("Empty path is not allowed");
        }
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean index = false;
        block5: for (pos = 0; pos < size; ++pos) {
            char c = path.charAt(pos);
            switch (c) {
                case '.': {
                    if (pos == 0 || pos == size - 1 || index) {
                        throw new IllegalArgumentException(String.format("Invalid path format at position %d: %s", pos, path));
                    }
                    Utils.append(elements, sb, path, pos);
                    continue block5;
                }
                case '[': {
                    if (index) {
                        throw new IllegalArgumentException(String.format("Invalid path format at position %d: %s", pos, path));
                    }
                    index = true;
                    Utils.append(elements, sb, path, pos);
                    sb.append(c);
                    continue block5;
                }
                case ']': {
                    if (!index || sb.length() == 1 || pos < size - 1 && path.charAt(pos + 1) != '.') {
                        throw new IllegalArgumentException(String.format("Invalid path format at position %d: %s", pos, path));
                    }
                    index = false;
                    sb.append(c);
                    continue block5;
                }
                default: {
                    if (index && !Character.isDigit(c)) {
                        throw new IllegalArgumentException(String.format("Invalid path format at position %d: %s", pos, path));
                    }
                    sb.append(c);
                }
            }
        }
        if (index) {
            throw new IllegalArgumentException(String.format("Invalid path format at position %d: %s", pos, path));
        }
        if (sb.length() > 0) {
            Utils.append(elements, sb, path, pos);
        }
        return elements.toArray(new String[elements.size()]);
    }

    public static boolean isSimpleArray(ConfigNode node) {
        if (node.getValue().isPresent()) {
            return false;
        }
        Collection children = node.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        if (!Utils.isArrayName(((ConfigNode)children.iterator().next()).getName())) {
            return false;
        }
        long gchildren = children.stream().flatMap(child -> child.getChildren().stream()).count();
        return gchildren == 0L;
    }

    public static boolean isSimpleMap(ConfigNode node) {
        if (node.getValue().isPresent()) {
            return false;
        }
        Collection children = node.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        if (Utils.isArrayName(((ConfigNode)children.iterator().next()).getName())) {
            return false;
        }
        long gchildren = children.stream().flatMap(child -> child.getChildren().stream()).count();
        return gchildren == 0L;
    }

    public static boolean isMapNode(ConfigNode node) {
        Collection children = node.getChildren();
        return children.size() > 0 && !Utils.isArrayName(((ConfigNode)children.iterator().next()).getName());
    }

    public static boolean isArrayNode(ConfigNode node) {
        Collection children = node.getChildren();
        return children.size() > 0 && Utils.isArrayName(((ConfigNode)children.iterator().next()).getName());
    }

    public static boolean isArrayName(String name) {
        return ARRAY_INDEX.matcher(name).matches();
    }

    private static void append(Collection<String> items, StringBuilder item, String path, int pos) {
        if (item.length() == 0) {
            throw new IllegalArgumentException(String.format("Invalid path format at position %d: %s", pos, path));
        }
        items.add(item.toString());
        item.delete(0, item.length());
    }

    @Generated
    private Utils() {
    }
}

