/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.eval;

import ascelion.config.eval.Buffer;
import ascelion.config.eval.Expression;
import java.beans.ConstructorProperties;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Replacer {
    private static final Logger LOG = LoggerFactory.getLogger(Replacer.class);
    private static final ThreadLocal<Deque<Buffer>> DUMP = new ThreadLocal<Deque<Buffer>>(){

        @Override
        protected Deque<Buffer> initialValue() {
            return new LinkedList<Buffer>();
        }
    };
    private final Expression exp;
    private final Deque<Buffer> vars = new LinkedList<Buffer>();
    private String lastVariable;

    Buffer replace(String expression) {
        this.lastVariable = expression;
        return this.replace(new Buffer(expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer replace(Buffer buf) {
        DUMP.get().addLast(buf);
        try {
            Buffer buffer = this.doReplace(buf);
            return buffer;
        }
        finally {
            Deque<Buffer> stack = DUMP.get();
            stack.pollLast();
            if (stack.isEmpty()) {
                DUMP.remove();
            }
        }
    }

    private Buffer doReplace(Buffer buf) {
        int ofs1 = buf.offset;
        while (ofs1 < buf.offset + buf.count) {
            int next = buf.match(this.exp.varPrefix, ofs1);
            if (next > ofs1) {
                ofs1 = next;
                continue;
            }
            int ofs2 = ofs1 + this.exp.varPrefix.length;
            int open = 1;
            while (ofs2 < buf.offset + buf.count) {
                next = buf.match(this.exp.varPrefix, ofs2);
                if (next == ofs2) {
                    ++open;
                    ofs2 += this.exp.varPrefix.length;
                    continue;
                }
                next = buf.match(this.exp.varSuffix, ofs2);
                if (next > ofs2) {
                    ofs2 = next;
                    continue;
                }
                if (--open > 0) {
                    ofs2 += this.exp.varSuffix.length;
                    continue;
                }
                this.handleLastSuffix(buf, ofs1, ofs2 - ofs1);
                break;
            }
            if (open <= 0) continue;
            break;
        }
        return buf;
    }

    private void pushName(Buffer var) {
        if (this.vars.contains(var)) {
            String m = String.format("Recursive definition for ${%s}: %s", var, this.vars.stream().map(Buffer::toString).collect(Collectors.joining(" -> ")));
            throw new IllegalStateException(m);
        }
        this.lastVariable = var.toString();
        this.vars.addLast(var);
    }

    private void popName() {
        this.vars.pollLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLastSuffix(Buffer buf, int ofs, int cnt) {
        String def;
        Buffer var;
        Buffer place = buf.newBuffer(ofs + this.exp.varPrefix.length, cnt - this.exp.varPrefix.length);
        this.replace(place);
        int defIx = place.find(this.exp.valueSep, 0);
        if (defIx < 0) {
            var = place;
            def = "";
        } else {
            var = place.subBuffer(0, defIx);
            def = place.subBuffer(defIx + this.exp.valueSep.length, place.count - defIx - this.exp.valueSep.length).toString();
        }
        Expression.Lookup res = this.exp.lookup.apply(var.toString());
        if (res.isUndefined()) {
            String text = String.format("Reference to undefined variable %s%s%s", new String(this.exp.varPrefix), var, new String(this.exp.varSuffix));
            if (LOG.isErrorEnabled()) {
                String dump = DUMP.get().stream().map(Buffer::toString).collect(Collectors.joining("\n\t -> ", text + "\n\t -> ", "\n"));
                LOG.error(dump);
            }
            throw new NoSuchElementException(text);
        }
        String val = res.getValue().orElse(def);
        this.pushName(var);
        try {
            val = this.replace(new Buffer(val)).toString();
        }
        finally {
            this.popName();
        }
        buf.replace(ofs, cnt + this.exp.varSuffix.length, val);
    }

    @ConstructorProperties(value={"exp"})
    @Generated
    public Replacer(Expression exp) {
        this.exp = exp;
    }

    @Generated
    public String getLastVariable() {
        return this.lastVariable;
    }
}

