/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.eval;

import ascelion.config.eval.Buffer;
import ascelion.config.eval.Replacer;
import java.beans.ConstructorProperties;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;

public final class Expression {
    static final String PREFIX_DEF = "${";
    static final String SUFFIX_DEF = "}";
    static final String VALUE_DEF = ":-";
    @NonNull
    Function<String, Lookup> lookup = x -> new Lookup(Optional.of(x));
    @NonNull
    char[] varPrefix = "${".toCharArray();
    @NonNull
    char[] valueSep = ":-".toCharArray();
    @NonNull
    char[] varSuffix = "}".toCharArray();

    public Result eval(String expression) {
        Replacer rep = new Replacer(this);
        Buffer buf = rep.replace(expression);
        String val = buf.toString().trim();
        return new Result(expression, val.isEmpty() ? null : val, rep.getLastVariable());
    }

    public Expression withLookup(@NonNull Function<String, Lookup> lookup) {
        if (lookup == null) {
            throw new NullPointerException("lookup is marked non-null but is null");
        }
        this.lookup = lookup;
        return this;
    }

    public Expression withPrefix(String expPrefix) {
        this.varPrefix = expPrefix.toCharArray();
        return this;
    }

    public Expression withValueSep(String expDefault) {
        this.valueSep = expDefault.toCharArray();
        return this;
    }

    public Expression withSuffix(String expSuffix) {
        this.varSuffix = expSuffix.toCharArray();
        return this;
    }

    public static class Result {
        private final String expression;
        private final String value;
        private final String lastVariable;

        @ConstructorProperties(value={"expression", "value", "lastVariable"})
        @Generated
        public Result(String expression, String value, String lastVariable) {
            this.expression = expression;
            this.value = value;
            this.lastVariable = lastVariable;
        }

        @Generated
        public String getExpression() {
            return this.expression;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public String getLastVariable() {
            return this.lastVariable;
        }
    }

    public static class Lookup {
        private final Optional<String> value;
        private final boolean undefined;

        public Lookup() {
            this(null, true);
        }

        public Lookup(Optional<String> value) {
            this(value, false);
        }

        public Optional<String> getValue() {
            if (this.undefined) {
                throw new NoSuchElementException();
            }
            return this.value;
        }

        @ConstructorProperties(value={"value", "undefined"})
        @Generated
        private Lookup(Optional<String> value, boolean undefined) {
            this.value = value;
            this.undefined = undefined;
        }

        @Generated
        public boolean isUndefined() {
            return this.undefined;
        }
    }
}

