/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.core;

import ascelion.config.api.ConfigNode;
import ascelion.config.api.ConfigProvider;
import ascelion.config.api.ConfigRoot;
import ascelion.config.core.ConfigNodeImpl;
import ascelion.config.core.ConfigRootBuilder;
import ascelion.config.eval.Expression;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.ConfigInput;
import ascelion.config.spi.ConverterFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigRootImpl
extends ConfigNodeImpl
implements ConfigRoot {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigRoot.class);
    private final Collection<ConfigInput> inputs = new CopyOnWriteArrayList<ConfigInput>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.LOADED);
    private final ConverterFactory converters;
    final Expression expression = new Expression();

    ConfigRootImpl() {
        this(new ConverterFactory(){

            public <T> ConfigConverter<T> get(Type type) {
                return node -> node.getValue();
            }
        });
    }

    public ConfigRootImpl(ConverterFactory converters) {
        this.converters = converters;
        this.expression.withLookup(x -> {
            Optional node = this.findNode((String)x);
            if (node.isPresent()) {
                return new Expression.Lookup(((ConfigNodeImpl)node.get()).getValue());
            }
            return new Expression.Lookup();
        });
    }

    public <T> Optional<T> getValue(String path, Type type) {
        Optional find = this.findNode(path);
        if (type == ConfigNode.class) {
            return find;
        }
        return find.flatMap(n -> (Optional)this.convert((ConfigNode)n, type));
    }

    void addConfigInputs(Collection<ConfigInput> inputs) {
        try {
            this.inputs.addAll(inputs);
        }
        finally {
            this.state.set(State.DIRTY);
        }
    }

    @Override
    Map<String, ConfigNodeImpl> children() {
        if (this.state.compareAndSet(State.DIRTY, State.LOADING)) {
            this.readInputs();
        }
        while (this.state.get() == State.LOADING) {
            Thread.yield();
        }
        return super.children();
    }

    String eval(String expression) {
        return this.expression.eval(expression).getValue();
    }

    @Override
    ConfigNodeImpl value(String value) {
        throw new UnsupportedOperationException();
    }

    private void readInputs() {
        try {
            ConfigRootBuilder bld = new ConfigRootBuilder();
            this.inputs.stream().sorted().forEach(i -> this.update(bld, (ConfigInput)i));
            super.children().clear();
            super.children().putAll(bld.get().children());
            this.state.set(State.LOADED);
        }
        catch (Throwable t) {
            this.state.set(State.DIRTY);
            throw t;
        }
    }

    private void update(ConfigRootBuilder bld, ConfigInput inp) {
        try {
            inp.update((ConfigProvider.Builder)bld);
        }
        catch (Exception e) {
            LOG.error(String.format("Error reading %s", inp.name()), (Throwable)e);
        }
    }

    private <T> T convert(ConfigNode node, Type type) {
        return (T)this.converters.get(type).convert(node);
    }

    static enum State {
        DIRTY,
        LOADING,
        LOADED;

    }
}

