/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.core;

import ascelion.config.api.ConfigProvider;
import ascelion.config.core.ConfigNodeImpl;
import ascelion.config.core.ConfigRootImpl;
import ascelion.config.spi.ConverterFactory;
import ascelion.config.spi.Utils;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigRootBuilder
implements ConfigProvider.Builder {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigProvider.Builder.class);
    private final Deque<ConfigNodeImpl> stack = new LinkedList<ConfigNodeImpl>();

    ConfigRootBuilder() {
        this.stack.push(new ConfigRootImpl());
    }

    ConfigRootBuilder(ConverterFactory converters) {
        this.stack.push(new ConfigRootImpl(converters));
    }

    public ConfigRootBuilder child() {
        ConfigNodeImpl node = this.stack.element();
        this.push(node.create("[" + node.children().size() + "]"));
        return this;
    }

    public ConfigRootBuilder child(String path) {
        String[] elements = Utils.pathElements((String)path);
        ConfigNodeImpl node = this.stack.element();
        for (String element : elements) {
            node = node.create(element);
        }
        this.push(node);
        return this;
    }

    public ConfigRootBuilder value(String value) {
        this.pull().value(value);
        return this;
    }

    public ConfigRootBuilder back() {
        this.pull();
        return this;
    }

    public ConfigRootBuilder set(Map<String, String> properties) {
        properties.forEach(this::set);
        return this;
    }

    public ConfigRootBuilder set(String path, String value) {
        try {
            String[] values = value.split("(?!\\\\),");
            if (values.length > 1) {
                this.child(path);
                for (String v : values) {
                    this.child().value(v);
                }
                this.back();
            } else if (value.length() > 0) {
                this.child(path).value(value);
            }
        }
        catch (Throwable t) {
            LOG.error(String.format("At %s, setting %s to %s", this.stack.peek().path, path, value), t);
            this.reset();
            throw t;
        }
        return this;
    }

    public ConfigRootImpl get() {
        this.reset();
        return (ConfigRootImpl)this.stack.pop();
    }

    private void reset() {
        while (this.stack.size() > 1) {
            this.pull();
        }
    }

    private void push(ConfigNodeImpl node) {
        LOG.trace("PUSH {}", (Object)node);
        this.stack.push(node);
    }

    private ConfigNodeImpl pull() {
        ConfigNodeImpl node = this.stack.pop();
        LOG.trace("PULL {}", (Object)node);
        return node;
    }
}

