/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.core;

import ascelion.config.api.ConfigProvider;
import ascelion.config.api.ConfigRoot;
import ascelion.config.convert.Converters;
import ascelion.config.core.ConfigRootImpl;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.ConfigInputReader;
import ascelion.config.spi.ConverterFactory;
import java.io.File;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;

public class ConfigProviderImpl
extends ConfigProvider {
    private static volatile ConfigRootImpl INSTANCE;
    private static Converters CONVERTERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<ConfigProviderImpl> clazz = ConfigProviderImpl.class;
        synchronized (ConfigProviderImpl.class) {
            CONVERTERS = null;
            INSTANCE = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigRoot get() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<ConfigProviderImpl> clazz = ConfigProviderImpl.class;
        synchronized (ConfigProviderImpl.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            CONVERTERS = new Converters();
            INSTANCE = new ConfigRootImpl((ConverterFactory)CONVERTERS);
            this.initConverters(ServiceLoader.load(ConfigConverter.class));
            this.initFactories(ServiceLoader.load(ConverterFactory.class));
            this.initReaders(ServiceLoader.load(ConfigInputReader.class));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected final void initReaders(Iterable<ConfigInputReader> readers) {
        String[] resources;
        HashSet<String> skip = new HashSet<String>();
        this.readAll(skip, readers, "");
        File directory = INSTANCE.getValue("ascelion.config.directory", File.class).orElse(null);
        for (String resource : resources = INSTANCE.getValue("ascelion.config.resources", String[].class).orElseGet(() -> new String[0])) {
            if (directory != null) {
                this.readAll(skip, readers, new File(directory, resource).getAbsolutePath());
            }
            this.readAll(skip, readers, resource);
        }
    }

    protected final void initFactories(Iterable<ConverterFactory> factories) {
        factories.forEach(arg_0 -> ((Converters)CONVERTERS).register(arg_0));
    }

    protected final void initConverters(Iterable<ConfigConverter> converters) {
        converters.forEach(arg_0 -> ((Converters)CONVERTERS).register(arg_0));
    }

    private void readAll(Set<String> skip, Iterable<ConfigInputReader> readers, String source) {
        if (skip.add(source)) {
            for (ConfigInputReader rd : readers) {
                INSTANCE.addConfigInputs(source.isEmpty() ? rd.read() : rd.read(source));
            }
        }
    }
}

