/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.core;

import ascelion.config.api.ConfigNode;
import ascelion.config.api.ConfigRoot;
import ascelion.config.core.ConfigRootImpl;
import ascelion.config.eval.Expression;
import ascelion.config.spi.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;

public class ConfigNodeImpl
implements ConfigNode {
    static final String VAR_PREFIX_PROP = "ascelion.config.var.prefix";
    static final String VAR_SEPARATOR_PROP = "ascelion.config.var.separator";
    static final String VAR_SUFFIX_PROP = "ascelion.config.var.suffix";
    final ConfigRootImpl root;
    final String name;
    final String path;
    private String value;
    private final Map<String, ConfigNodeImpl> children = new TreeMap<String, ConfigNodeImpl>();

    ConfigNodeImpl() {
        this.root = (ConfigRootImpl)this;
        this.name = "";
        this.path = "";
    }

    private ConfigNodeImpl(ConfigNodeImpl parent, String name) {
        this.root = parent.root;
        this.name = name;
        this.path = parent.newPath(name);
    }

    public String toString() {
        return String.format("[path: %s, value: %s, children: %d]", this.path, this.value, this.children.size());
    }

    public ConfigRoot root() {
        return this.root;
    }

    public final Optional<String> getValue() {
        return Optional.ofNullable(this.value).map(this.root::eval);
    }

    public Optional<ConfigNode> getNode(String path) {
        return this.findNode(path);
    }

    public final Collection<ConfigNode> getChildren() {
        Collection<ConfigNode> nodes = this.children().values();
        if (nodes.size() > 0) {
            return nodes;
        }
        if (this.value == null) {
            return Collections.emptyList();
        }
        Expression.Result eval = this.root.expression.eval(this.value);
        String newPath = eval.getValue() != null ? eval.getValue() : eval.getLastVariable();
        if (this.value.equals(newPath)) {
            return Collections.emptyList();
        }
        return this.root.getValue(newPath, ConfigNode.class).map(ConfigNode::getChildren).orElse(Collections.emptyList());
    }

    String newPath(String name) {
        if (name.isEmpty() || name.contains(".")) {
            throw new IllegalArgumentException(name);
        }
        return this.path.isEmpty() ? name : this.path + (Utils.isArrayName((String)name) ? name : "." + name);
    }

    final <N extends ConfigNode> Optional<N> findNode(String path) {
        String[] elements = Utils.pathElements((String)path);
        ConfigNodeImpl node = this;
        for (int k = 0; node != null && k < elements.length; node = node.child(elements[k]), ++k) {
        }
        return Optional.ofNullable(node);
    }

    private ConfigNodeImpl child(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The node name cannot be empty");
        }
        return this.children().get(name);
    }

    final ConfigNodeImpl create(String name) {
        boolean isArray = Utils.isArrayName((String)name);
        if (isArray && Utils.isMapNode((ConfigNode)this)) {
            throw new IllegalStateException(String.format("The node %s already contains a map", this.path));
        }
        if (!isArray && Utils.isArrayNode((ConfigNode)this)) {
            throw new IllegalStateException(String.format("The node %s already contains an array", this.path));
        }
        return this.children().computeIfAbsent(name, n -> new ConfigNodeImpl(this, name));
    }

    Map<String, ConfigNodeImpl> children() {
        return this.children;
    }

    ConfigNodeImpl value(String value) {
        switch (this.path) {
            case "ascelion.config.var.prefix": {
                this.root.expression.withPrefix(value);
                break;
            }
            case "ascelion.config.var.separator": {
                this.root.expression.withValueSep(value);
                break;
            }
            case "ascelion.config.var.suffix": {
                this.root.expression.withSuffix(value);
            }
        }
        this.value = value;
        return this;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }
}

