package ascelion.config.eval;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

public final class Expression {
	static final String PREFIX_DEF = "${";
	static final String SUFFIX_DEF = "}";
	static final String VALUE_DEF = ":-";

	@NonNull
	Function<String, Lookup> lookup = x -> new Lookup(Optional.of(x));
	@NonNull
	char[] varPrefix = PREFIX_DEF.toCharArray();
	@NonNull
	char[] valueSep = VALUE_DEF.toCharArray();
	@NonNull
	char[] varSuffix = SUFFIX_DEF.toCharArray();

	@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
	static public class Lookup {
		private final Optional<String> value;
		@Getter
		private final boolean undefined;

		public Lookup() {
			this(null, true);
		}

		public Lookup(Optional<String> value) {
			this(value, false);
		}

		public Optional<String> getValue() {
			if (this.undefined) {
				throw new NoSuchElementException();
			}

			return this.value;
		}
	}

	@RequiredArgsConstructor
	@Getter
	static public class Result {
		private final String expression;
		private final String value;
		private final String lastVariable;
	}

	public Result eval(String expression) {
		final Replacer rep = new Replacer(this);
		final Buffer buf = rep.replace(expression);
		final String val = buf.toString().trim();

		return new Result(expression, val.isEmpty() ? null : val, rep.getLastVariable());
	}

	public Expression withLookup(@NonNull Function<String, Lookup> lookup) {
		this.lookup = lookup;

		return this;
	}

	public Expression withPrefix(String expPrefix) {
		this.varPrefix = expPrefix.toCharArray();

		return this;
	}

	public Expression withValueSep(String expDefault) {
		this.valueSep = expDefault.toCharArray();

		return this;
	}

	public Expression withSuffix(String expSuffix) {
		this.varSuffix = expSuffix.toCharArray();

		return this;
	}
}
