/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import java.beans.ConstructorProperties;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Priority;
import lombok.Generated;

final class PrioritizedCollection<T>
extends AbstractCollection<T> {
    private final List<Holder<T>> delegate = new ArrayList<Holder<T>>();

    PrioritizedCollection() {
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Holder<T>> delegate = this.delegate.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                return ((Holder)delegate.next()).instance;
            }
        };
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public boolean add(T e, int p) {
        this.delegate.add(new Holder<T>(e, p));
        Collections.sort(this.delegate);
        return true;
    }

    @Override
    public boolean add(T e) {
        this.delegate.add(new Holder<T>(e));
        Collections.sort(this.delegate);
        return true;
    }

    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.delegate.get((int)0).instance;
    }

    static class Holder<T>
    implements Comparable<Holder<T>> {
        final T instance;
        final int priority;

        Holder(T instance) {
            this.instance = instance;
            this.priority = Optional.ofNullable(instance.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(0);
        }

        @Override
        public int compareTo(Holder<T> that) {
            return Integer.compare(this.priority, that.priority);
        }

        @ConstructorProperties(value={"instance", "priority"})
        @Generated
        Holder(T instance, int priority) {
            this.instance = instance;
            this.priority = priority;
        }
    }
}

