/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import ascelion.config.api.ConfigNode;
import ascelion.config.convert.WrappedConverter;
import ascelion.config.spi.ConfigConverter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

final class PrimitiveArrayConverter<A, T>
extends WrappedConverter<A, T> {
    PrimitiveArrayConverter(Type type, ConfigConverter<T> conv) {
        super(type, conv);
    }

    public Optional<A> convert(ConfigNode node) {
        Collection children = node.getChildren();
        if (children.isEmpty() && !node.getValue().isPresent()) {
            return Optional.empty();
        }
        Stream<Optional> stream = children.isEmpty() ? Stream.of(this.conv.convert(node)) : children.stream().map(arg_0 -> ((ConfigConverter)this.conv).convert(arg_0));
        if (this.type == Integer.TYPE) {
            return Optional.of(stream.filter(Optional::isPresent).map(Optional::get).map(Integer.class::cast).mapToInt(Number::intValue).toArray());
        }
        if (this.type == Long.TYPE) {
            return Optional.of(stream.filter(Optional::isPresent).map(Optional::get).map(Long.class::cast).mapToLong(Number::longValue).toArray());
        }
        if (this.type == Double.class) {
            return Optional.of(stream.filter(Optional::isPresent).map(Optional::get).map(Double.class::cast).mapToDouble(Number::doubleValue).toArray());
        }
        throw new UnsupportedOperationException();
    }
}

