/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import ascelion.config.api.ConfigNode;
import ascelion.config.convert.WrappedConverter;
import ascelion.config.spi.ConfigConverter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

final class MapConverter<M extends Map<String, T>, T>
extends WrappedConverter<M, T> {
    private final Supplier<M> sup;

    MapConverter(Supplier<M> sup, Type type, ConfigConverter<T> conv) {
        super(type, conv);
        this.sup = sup;
    }

    public Optional<M> convert(ConfigNode node) {
        Collection children = node.getChildren();
        if (children.isEmpty()) {
            return Optional.empty();
        }
        Map map = (Map)this.sup.get();
        String base = node.getPath();
        int baseLen = base.length() + 1;
        for (ConfigNode child : children) {
            Optional opt = this.conv.convert(child);
            if (!opt.isPresent()) continue;
            String key = child.getPath().substring(baseLen);
            map.put(key, opt.get());
        }
        return Optional.of(map);
    }
}

