/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import ascelion.config.api.ConfigNode;
import ascelion.config.api.ConfigValue;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.ConverterFactory;
import io.leangen.geantyref.GenericTypeReflector;
import java.beans.Introspector;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

final class InterfaceValue
implements InvocationHandler {
    private static final Set<Method> O_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList(Object.class.getMethods())));
    private static final Constructor<MethodHandles.Lookup> LOOKUP;
    private final Map<Method, ConfigValue> names = new HashMap<Method, ConfigValue>();
    private final Class<?> type;
    private final ConfigNode node;
    private final ConverterFactory converters;

    InterfaceValue(Class<?> type, ConfigNode node, ConverterFactory converters) {
        this.type = type;
        this.node = node;
        this.converters = converters;
        Stream.of(type.getMethods()).filter(m -> !m.isDefault()).filter(m -> m.getParameterTypes().length == 0).filter(m -> m.getReturnType() != Void.TYPE).forEach(this::addName);
    }

    public String toString() {
        return String.format("%s[%s]", this.type.getSimpleName(), this.node.getPath());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (O_METHODS.contains(method)) {
            return method.invoke((Object)this, args);
        }
        if (this.names.containsKey(method)) {
            ConfigValue a = this.names.get(method);
            Type t = GenericTypeReflector.getExactReturnType((Method)method, this.type);
            return this.node.getNode(a.value()).flatMap(arg_0 -> ((ConfigConverter)this.converters.get(t)).convert(arg_0)).orElse(null);
        }
        if (method.isDefault()) {
            Class<?> cls = method.getDeclaringClass();
            MethodHandle han = LOOKUP.newInstance(cls, -1).unreflectSpecial(method, cls).bindTo(proxy);
            return han.invokeWithArguments(args);
        }
        throw new RuntimeException(String.format("Cannot handle method %s#%s", this.type.getName(), method.getName()));
    }

    private void addName(Method m) {
        String name = Introspector.decapitalize(m.getName().replaceAll("^(is|get)", ""));
        Class<ConfigConverter> conv = ConfigConverter.class;
        ConfigValue anno = m.getAnnotation(ConfigValue.class);
        this.names.put(m, anno);
    }

    static {
        try {
            LOOKUP = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            LOOKUP.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

