/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import ascelion.config.api.ConfigException;
import ascelion.config.api.ConfigNode;
import ascelion.config.convert.ArrayConverter;
import ascelion.config.convert.CollectionConverter;
import ascelion.config.convert.EnumConverter;
import ascelion.config.convert.InterfaceConverter;
import ascelion.config.convert.MapConverter;
import ascelion.config.convert.PrimitiveArrayConverter;
import ascelion.config.convert.PrioritizedCollection;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.ConverterFactory;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Converters
implements ConverterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Converters.class);
    static final TypeVariable<? extends Class<?>> CV_TYPE = ConfigConverter.class.getTypeParameters()[0];
    private static final String[] CREATE_METHODS = new String[]{"valueOf", "parse", "create", "from", "fromValue", "of"};
    private final Map<Type, PrioritizedCollection<ConfigConverter<?>>> cached = new HashMap();
    private final PrioritizedCollection<ConverterFactory> factories = new PrioritizedCollection();

    public Converters() {
        this.addFunction((Type)((Object)String.class), UnaryOperator.identity());
        this.addFunction(Boolean.TYPE, Boolean::valueOf);
        this.addFunction(Byte.TYPE, Byte::parseByte);
        this.addFunction(Short.TYPE, Short::parseShort);
        this.addFunction(Integer.TYPE, Integer::parseInt);
        this.addFunction(Long.TYPE, Long::parseLong);
        this.addFunction(Float.TYPE, Float::parseFloat);
        this.addFunction(Double.TYPE, Double::parseDouble);
        this.addFunction((Type)((Object)Boolean.class), (Function)Boolean::valueOf);
        this.addFunction((Type)((Object)Byte.class), (Function)Byte::parseByte);
        this.addFunction((Type)((Object)Short.class), (Function)Short::parseShort);
        this.addFunction((Type)((Object)Integer.class), (Function)Integer::parseInt);
        this.addFunction((Type)((Object)Long.class), (Function)Long::parseLong);
        this.addFunction((Type)((Object)Float.class), (Function)Float::parseFloat);
        this.addFunction((Type)((Object)Double.class), (Function)Double::parseDouble);
    }

    public void register(ConfigConverter<?> converter) {
        Class<?> type = converter.getClass();
        this.cached.compute(GenericTypeReflector.getTypeParameter(type, CV_TYPE), (t, s) -> this.addConverter((Type)t, (PrioritizedCollection<ConfigConverter<?>>)s, converter));
    }

    public void register(ConverterFactory factory) {
        LOG.debug("Registering {}", (Object)factory.getClass().getName());
        this.factories.add(factory);
    }

    public <T> ConfigConverter<T> get(Type type) {
        return (ConfigConverter)this.cached.computeIfAbsent(type, t -> this.addConverter((Type)t, null, this.inferConverter((Type)t), Integer.MAX_VALUE)).head();
    }

    private <T> void addFunction(Type type, Function<String, T> func) {
        ConfigConverter conv = node -> node.getValue().map(func);
        this.cached.compute(type, (t, s) -> this.addConverter((Type)t, (PrioritizedCollection<ConfigConverter<?>>)s, (ConfigConverter<?>)conv, Integer.MAX_VALUE));
    }

    private PrioritizedCollection<ConfigConverter<?>> addConverter(Type type, PrioritizedCollection<ConfigConverter<?>> col, ConfigConverter<?> cvt) {
        if (col == null) {
            col = new PrioritizedCollection();
        }
        LOG.debug("Registering {} for {}", (Object)cvt.getClass().getName(), (Object)type.getTypeName());
        col.add(cvt);
        return col;
    }

    private PrioritizedCollection<ConfigConverter<?>> addConverter(Type type, PrioritizedCollection<ConfigConverter<?>> col, ConfigConverter<?> cvt, int pri) {
        if (col == null) {
            col = new PrioritizedCollection();
        }
        LOG.debug("Registering {} for {}", (Object)cvt.getClass().getName(), (Object)type.getTypeName());
        col.add(cvt, pri);
        return col;
    }

    private <T> ConfigConverter<T> inferConverter(Type type) {
        ConfigConverter conv;
        if (type instanceof ParameterizedType && (conv = this.parameterizedTypeConverter((ParameterizedType)type)) != null) {
            return conv;
        }
        if (type instanceof GenericArrayType && (conv = this.genericArrayConverter((GenericArrayType)type)) != null) {
            return conv;
        }
        if (type instanceof Class && (conv = this.classConverter((Class)type)) != null) {
            return conv;
        }
        for (ConverterFactory factory : this.factories) {
            conv = factory.get(type);
            if (conv == null) continue;
            return conv;
        }
        throw new ConfigException(String.format("NO WAY to construct a %s", type.getTypeName()));
    }

    private <T> ConfigConverter<T> parameterizedTypeConverter(ParameterizedType type) {
        Type rawType = type.getRawType();
        if (!(rawType instanceof Class)) {
            return null;
        }
        Class rawClass = (Class)rawType;
        if (Collection.class.isAssignableFrom(rawClass)) {
            Type actual = type.getActualTypeArguments()[0];
            ConfigConverter<T> conv = this.get(actual);
            Supplier<Collection> sup = null;
            if (rawClass.isInterface()) {
                if (SortedSet.class == rawClass) {
                    if (rawClass.isAssignableFrom(TreeSet.class)) {
                        sup = TreeSet::new;
                    }
                } else if (Set.class == rawClass) {
                    if (rawClass.isAssignableFrom(HashSet.class)) {
                        sup = HashSet::new;
                    }
                } else if (rawClass.isAssignableFrom(ArrayList.class)) {
                    sup = ArrayList::new;
                }
            } else {
                sup = () -> (Collection)this.newInstance(rawClass);
            }
            if (sup != null) {
                return new CollectionConverter<Collection, T>(sup, actual, conv);
            }
            return null;
        }
        if (Map.class.isAssignableFrom(rawClass)) {
            Type actual = type.getActualTypeArguments()[1];
            ConfigConverter<T> conv = this.get(actual);
            Supplier<Map> sup = null;
            if (rawClass.isInterface()) {
                if (SortedMap.class == rawClass) {
                    if (rawClass.isAssignableFrom(TreeMap.class)) {
                        sup = TreeMap::new;
                    }
                } else if (rawClass.isAssignableFrom(HashMap.class)) {
                    sup = HashMap::new;
                }
            } else {
                sup = () -> (Map)this.newInstance(rawClass);
            }
            return new MapConverter<Map, T>(sup, actual, conv);
        }
        return null;
    }

    private <T> T newInstance(Class<T> type) {
        return type.newInstance();
    }

    private <T> ConfigConverter<T> genericArrayConverter(GenericArrayType type) {
        Type compType = type.getGenericComponentType();
        return new ArrayConverter<T>(compType, this.get(compType));
    }

    private <T> ConfigConverter<T> classConverter(Class<T> type) {
        if (type.isEnum()) {
            return new EnumConverter<T>(type);
        }
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            if (compType.isPrimitive()) {
                return new PrimitiveArrayConverter(compType, this.get(compType));
            }
            return new ArrayConverter<T>(compType, this.get(compType));
        }
        if (type.isInterface()) {
            return new InterfaceConverter<T>(type, this);
        }
        return this.fromClass(type);
    }

    private <T> ConfigConverter<T> fromClass(Class<T> type) {
        ConfigConverter<T> c = this.fromConstructor(type, String.class);
        if (c != null) {
            return c;
        }
        c = this.fromConstructor(type, CharSequence.class);
        if (c != null) {
            return c;
        }
        for (String name : CREATE_METHODS) {
            c = this.fromMethod(type, name, String.class);
            if (c != null) {
                return c;
            }
            c = this.fromMethod(type, name, CharSequence.class);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private <T> ConfigConverter<T> fromConstructor(Class<T> type, Class<? extends CharSequence> paramType) {
        Constructor<T> c;
        try {
            c = type.getDeclaredConstructor(paramType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return new ConfigConverter<T>(){

            public Optional<T> convert(ConfigNode node) {
                String value = node.getValue().orElse(null);
                if (value == null) {
                    return Optional.empty();
                }
                c.setAccessible(true);
                return Optional.of(c.newInstance(value));
            }
        };
    }

    private <T> ConfigConverter<T> fromMethod(Class<T> type, String name, Class<? extends CharSequence> paramType) {
        Method m;
        try {
            m = type.getDeclaredMethod(name, paramType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            return null;
        }
        return new ConfigConverter<T>(){

            public Optional<T> convert(ConfigNode node) {
                String value = node.getValue().orElse(null);
                if (value == null) {
                    return Optional.empty();
                }
                m.setAccessible(true);
                return Optional.of(m.invoke(null, value));
            }
        };
    }
}

