/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import ascelion.config.api.ConfigNode;
import ascelion.config.convert.WrappedConverter;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.Utils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class CollectionConverter<C extends Collection<T>, T>
extends WrappedConverter<C, T> {
    private final Supplier<C> sup;

    CollectionConverter(Supplier<C> sup, Type type, ConfigConverter<T> conv) {
        super(type, conv);
        this.sup = sup;
    }

    public Optional<C> convert(ConfigNode node) {
        Collection children = node.getChildren();
        Stream<Object> stream = Utils.isArrayNode((ConfigNode)node) ? children.stream().map(arg_0 -> ((ConfigConverter)this.conv).convert(arg_0)) : (node.getValue().isPresent() ? Stream.of(this.conv.convert(node)) : Stream.empty());
        Collection col = (Collection)this.sup.get();
        stream.filter(Optional::isPresent).map(Optional::get).forEach(col::add);
        return Optional.of(col);
    }
}

