/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.convert;

import ascelion.config.api.ConfigNode;
import ascelion.config.convert.WrappedConverter;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;

final class ArrayConverter<T>
extends WrappedConverter<Object[], T> {
    ArrayConverter(Type type, ConfigConverter<T> conv) {
        super(type, conv);
    }

    public Optional<Object[]> convert(ConfigNode node) {
        Collection children = node.getChildren();
        Stream<Optional> stream = Utils.isArrayNode((ConfigNode)node) ? children.stream().map(arg_0 -> ((ConfigConverter)this.conv).convert(arg_0)) : (node.getValue().isPresent() ? Stream.of(this.conv.convert(node)) : Stream.empty());
        A[] result = stream.filter(Optional::isPresent).map(Optional::get).toArray(this::newArray);
        return Optional.of(result);
    }

    private Object[] newArray(int n) {
        return this.type instanceof Class ? (Object[])Array.newInstance((Class)this.type, n) : (Object[])Array.newInstance(Object.class, n);
    }
}

