/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.cdi;

import ascelion.config.api.ConfigRoot;
import ascelion.config.api.ConfigValue;
import ascelion.config.cdi.Primitives;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

class ConfigValueProducer {
    @Inject
    private ConfigRoot root;

    ConfigValueProducer() {
    }

    @ConfigValue(value="")
    Object produceValue(InjectionPoint ip) {
        ConfigValue annotation = (ConfigValue)ip.getAnnotated().getAnnotation(ConfigValue.class);
        String property = annotation.value();
        Type type = ip.getType();
        Optional opt = this.root.getValue(property, type);
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Optional.class) {
            return opt;
        }
        if (annotation.required()) {
            return opt.orElseThrow(() -> new NoSuchElementException(String.format("Reference to undefined property %s at %s", property, ip.getMember())));
        }
        return opt.orElseGet(() -> Primitives.toDefault(type));
    }
}

