/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.cdi;

import ascelion.cdi.metadata.AnnotatedTypeModifier;
import ascelion.config.api.ConfigPrefix;
import ascelion.config.api.ConfigValue;
import ascelion.config.spi.Utils;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.literal.InjectLiteral;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigProcessor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigProcessor.class);
    private final AnnotatedTypeModifier<T> tmod;
    private final String prefix;
    private final String typeName;
    private final boolean hasPrefix;
    private final Set<ConfigValue> values = new HashSet<ConfigValue>();
    private final Set<AnnotatedMethod<T>> methods = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<AnnotatedField<T>> fields = Collections.newSetFromMap(new IdentityHashMap());

    ConfigProcessor(AnnotatedType<T> type) {
        this.tmod = AnnotatedTypeModifier.create(type);
        this.typeName = type.getJavaClass().getCanonicalName();
        this.prefix = Optional.ofNullable(type.getAnnotation(ConfigPrefix.class)).map(ConfigPrefix::value).orElse(null);
        this.hasPrefix = this.prefix != null && this.prefix.length() > 0;
        this.processCallables(this.tmod.getCallables());
        this.processFields(this.tmod.getFields());
    }

    Set<ConfigValue> values() {
        return this.values;
    }

    AnnotatedType<T> type() {
        return this.tmod.get();
    }

    Set<AnnotatedField<T>> fields() {
        return Collections.unmodifiableSet(this.fields);
    }

    Set<AnnotatedMethod<T>> methods() {
        return Collections.unmodifiableSet(this.methods);
    }

    private void processCallables(Set<AnnotatedCallable<T>> callables) {
        callables.stream().filter(callable -> !callable.isAnnotationPresent(Produces.class)).filter(callable -> callable.getParameters().size() > 0).filter(callable -> callable.getParameters().stream().anyMatch(p -> p.isAnnotationPresent(ConfigValue.class))).forEach(callable -> this.processCallable((AnnotatedCallable<T>)callable));
    }

    private void processFields(Set<AnnotatedField<T>> fields) {
        fields.stream().filter(field -> !field.isAnnotationPresent(Produces.class)).filter(field -> field.isAnnotationPresent(ConfigValue.class)).forEach(field -> this.processField((AnnotatedField<T>)field));
    }

    private void processCallable(AnnotatedCallable<T> callable) {
        Executable executable = (Executable)callable.getJavaMember();
        List parameters = callable.getParameters();
        if (parameters.size() == 1) {
            AnnotatedParameter parameter = (AnnotatedParameter)parameters.get(0);
            ConfigValue cval = (ConfigValue)parameter.getAnnotation(ConfigValue.class);
            AnnotatedTypeModifier.Annotations pmod = this.tmod.executableParam(executable, 0);
            String name = executable.getName();
            if (name.startsWith("set")) {
                if (cval.required()) {
                    this.tmod.executable(executable).add((Annotation)InjectLiteral.INSTANCE);
                } else {
                    this.tmod.executable(executable).remove(Inject.class);
                    LOG.debug("Removing injection from setter in {}", (Object)executable);
                }
                this.methods.add((AnnotatedMethod)callable);
                name = Introspector.decapitalize(name.substring(3));
            } else {
                this.tmod.executable(executable).add((Annotation)InjectLiteral.INSTANCE);
            }
            this.updateAnnotation(cval, pmod, name);
        } else {
            this.tmod.executable(executable).add((Annotation)InjectLiteral.INSTANCE);
            for (int k = 0; k < parameters.size(); ++k) {
                AnnotatedParameter parameter = (AnnotatedParameter)parameters.get(k);
                if (!parameter.isAnnotationPresent(ConfigValue.class)) continue;
                ConfigValue cval = (ConfigValue)parameter.getAnnotation(ConfigValue.class);
                AnnotatedTypeModifier.Annotations pmod = this.tmod.executableParam(executable, k);
                this.updateAnnotation(cval, pmod, "");
            }
        }
    }

    private void processField(AnnotatedField<T> annotated) {
        ConfigValue cval = (ConfigValue)annotated.getAnnotation(ConfigValue.class);
        AnnotatedTypeModifier.Annotations fmod = this.tmod.field(annotated);
        Field field = annotated.getJavaMember();
        if (cval.required()) {
            fmod.add((Annotation)InjectLiteral.INSTANCE);
        }
        this.fields.add(annotated);
        this.updateAnnotation(cval, fmod, field.getName());
    }

    private ConfigValue updateAnnotation(ConfigValue cval, AnnotatedTypeModifier.Annotations<T, ?> amod, String name) {
        String prop = cval.value();
        amod.remove(ConfigValue.class);
        StringBuilder expr = new StringBuilder();
        if (prop.isEmpty()) {
            if (name.isEmpty()) {
                throw new DeploymentException(String.format("Configuration name is required for %s", amod.and().get()));
            }
            if (cval.usePrefix()) {
                if (this.hasPrefix) {
                    expr.append(this.prefix);
                } else {
                    expr.append(this.typeName);
                }
                if (!Utils.isArrayName((String)expr.toString())) {
                    expr.append(".");
                }
            }
            expr.append(name);
        } else {
            if (cval.usePrefix() && this.hasPrefix) {
                expr.append(this.prefix);
                if (!Utils.isArrayName((String)this.prefix)) {
                    expr.append(".");
                }
            }
            expr.append(prop);
        }
        cval = ConfigValue.Literal.from((ConfigValue)cval).value(expr.toString()).build();
        this.values.add(cval);
        amod.add((Annotation)cval);
        LOG.debug("Set {} to {}", (Object)expr, (Object)amod.get());
        return cval;
    }
}

