/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.cdi;

import ascelion.config.api.ConfigRoot;
import ascelion.config.api.ConfigValue;
import ascelion.config.cdi.ConfigProcessor;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigInjectionTarget<T>
implements InjectionTarget<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigInjectionTarget.class);
    private final BeanManager bm;
    private final InjectionTarget<T> delegate;
    private final ConfigProcessor<T> processor;

    public T produce(CreationalContext<T> ctx) {
        return (T)this.delegate.produce(ctx);
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.delegate.inject(instance, ctx);
        Bean cfb = (Bean)this.bm.getBeans(ConfigRoot.class, new Annotation[0]).iterator().next();
        CreationalContext ccx = this.bm.createCreationalContext((Contextual)cfb);
        ConfigRoot root = (ConfigRoot)this.bm.getReference(cfb, ConfigRoot.class, ccx);
        this.processor.fields().stream().filter(f -> f.getAnnotation(Inject.class) == null).forEach(f -> ConfigInjectionTarget.inject(root, instance, f));
        this.processor.methods().stream().filter(m -> m.getAnnotation(Inject.class) == null).forEach(m -> ConfigInjectionTarget.inject(root, instance, m));
    }

    public void postConstruct(T instance) {
        this.delegate.postConstruct(instance);
    }

    public void dispose(T instance) {
        this.delegate.dispose(instance);
    }

    public void preDestroy(T instance) {
        this.delegate.preDestroy(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    static <T> void inject(ConfigRoot root, T instance, AnnotatedField<T> annotated) {
        ConfigValue cval = (ConfigValue)annotated.getAnnotation(ConfigValue.class);
        String prop = cval.value();
        Type type = annotated.getBaseType();
        Optional value = root.getValue(prop, type);
        if (value.isPresent()) {
            Field field = annotated.getJavaMember();
            LOG.debug("Invoking setter {}", (Object)field);
            field.setAccessible(true);
            field.set(instance, value.get());
        }
    }

    static <T> void inject(ConfigRoot root, T instance, AnnotatedMethod<T> annotated) {
        AnnotatedParameter param = (AnnotatedParameter)annotated.getParameters().get(0);
        ConfigValue cval = (ConfigValue)param.getAnnotation(ConfigValue.class);
        String prop = cval.value();
        Type type = param.getBaseType();
        Optional value = root.getValue(prop, type);
        if (value.isPresent()) {
            Method method = annotated.getJavaMember();
            LOG.debug("Invoking setter {}", annotated);
            method.setAccessible(true);
            method.invoke(instance, value.get());
        }
    }

    @ConstructorProperties(value={"bm", "delegate", "processor"})
    @Generated
    public ConfigInjectionTarget(BeanManager bm, InjectionTarget<T> delegate, ConfigProcessor<T> processor) {
        this.bm = bm;
        this.delegate = delegate;
        this.processor = processor;
    }
}

