/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.cdi;

import ascelion.cdi.bean.BeanAttributesModifier;
import ascelion.cdi.metadata.AnnotatedTypeModifier;
import ascelion.config.api.ConfigValue;
import ascelion.config.cdi.BeanConverterFactory;
import ascelion.config.cdi.CDIConfigProvider;
import ascelion.config.cdi.ConfigInjectionTarget;
import ascelion.config.cdi.ConfigProcessor;
import ascelion.config.cdi.ConfigValueProducer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProducerFactory;
import javax.enterprise.inject.spi.WithAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigExtension
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigExtension.class);
    private AnnotatedType<ConfigValueProducer> prodType;
    private Bean<ConfigValueProducer> prodBean;
    private final Map<Class<?>, ConfigProcessor<?>> processors = new IdentityHashMap();
    private final Set<Type> types = new HashSet<Type>();
    private final Set<Type> skippedTypes = new HashSet<Type>();

    void beforeBeanDiscovery(BeanManager bm, @Observes BeforeBeanDiscovery event) {
        event.addQualifier(AnnotatedTypeModifier.makeQualifier((AnnotatedType)bm.createAnnotatedType(ConfigValue.class), (String[])new String[0]));
        LOG.info("Created qualifier @ConfigValue");
        this.prodType = bm.createAnnotatedType(ConfigValueProducer.class);
        event.addAnnotatedType(this.prodType, ConfigValueProducer.class.getName());
        event.addAnnotatedType(BeanConverterFactory.class, BeanConverterFactory.class.getName());
        event.addAnnotatedType(CDIConfigProvider.class, CDIConfigProvider.class.getName());
    }

    void processConfigProducerBean(@Observes ProcessManagedBean<ConfigValueProducer> event) {
        this.prodBean = event.getBean();
    }

    <X> void processConfigValue(BeanManager bm, @Observes @WithAnnotations(value={ConfigValue.class}) ProcessAnnotatedType<X> event) {
        AnnotatedType type = event.getAnnotatedType();
        LOG.info("Processing type {}", (Object)type);
        ConfigProcessor processor = new ConfigProcessor(type);
        if (processor.values().size() > 0) {
            type = processor.type();
            LOG.info("Updated type {}", type);
            event.setAnnotatedType(type);
            this.processors.put(type.getJavaClass(), processor);
        }
    }

    <T, X> void processInjectionPoint(BeanManager bm, @Observes ProcessInjectionPoint<T, X> event) {
        Type type;
        InjectionPoint ijp = event.getInjectionPoint();
        Annotated annotated = ijp.getAnnotated();
        if (annotated.isAnnotationPresent(ConfigValue.class) && this.types.add(type = ijp.getType())) {
            LOG.debug("May need to create @ConfigValue producer for {}", (Object)type);
        }
    }

    <X> void processInjectionTarget(BeanManager bm, @Observes ProcessInjectionTarget<X> event) {
        Class javaClass = event.getAnnotatedType().getJavaClass();
        ConfigProcessor<?> processor = this.processors.get(javaClass);
        if (processor != null) {
            InjectionTarget it = event.getInjectionTarget();
            LOG.info("Overring injection of {}", (Object)it);
            event.setInjectionTarget(new ConfigInjectionTarget(bm, it, processor));
        }
    }

    void processProducer(BeanManager bm, @Observes ProcessProducer<?, ?> event) {
        Type type;
        AnnotatedMember annotated = event.getAnnotatedMember();
        if (annotated.isAnnotationPresent(ConfigValue.class) && this.skippedTypes.add(type = event.getAnnotatedMember().getBaseType())) {
            LOG.debug("Will not create @ConfigValue producer for {} -- ", (Object)type, (Object)annotated);
            if (type instanceof ParameterizedType) {
                this.skippedTypes.add(((ParameterizedType)type).getRawType());
            }
        }
    }

    void afterBeanDiscovery(BeanManager bm, @Observes AfterBeanDiscovery event) {
        this.types.removeIf(this::filterType);
        if (this.types.isEmpty()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Adding @ConfigValue producer(s) for {}", (Object)this.types.stream().map(Type::getTypeName).collect(Collectors.joining(", ")));
        }
        AnnotatedMethod method = this.prodType.getMethods().stream().filter(m -> m.getJavaMember().getName().equals("produceValue")).findFirst().get();
        ProducerFactory prodFactory = bm.getProducerFactory(method, this.prodBean);
        BeanAttributesModifier prodAttributes = BeanAttributesModifier.create((BeanAttributes)bm.createBeanAttributes((AnnotatedMember)method));
        prodAttributes.types().clear().addAll(this.types);
        Bean prodBean = bm.createBean(prodAttributes.get(), ConfigValueProducer.class, prodFactory);
        event.addBean(prodBean);
    }

    private boolean filterType(Type type) {
        if (this.skippedTypes.contains(type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (this.skippedTypes.contains(rawType)) {
                return true;
            }
            if (rawType instanceof Class) {
                Class rawClass = (Class)rawType;
                return this.skippedTypes.stream().filter(t -> Class.class.isInstance(t)).map(Class.class::cast).anyMatch(c -> c.isAssignableFrom(rawClass));
            }
        }
        return false;
    }
}

