/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.cdi;

import ascelion.cdi.metadata.AnnotatedTypeModifier;
import ascelion.config.api.ConfigPrefix;
import ascelion.config.api.ConfigRoot;
import ascelion.config.api.ConfigValue;
import ascelion.config.cdi.ConfigInjectionTarget;
import ascelion.config.cdi.ConfigProcessor;
import ascelion.config.spi.ConfigConverter;
import ascelion.config.spi.ConverterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Unmanaged;
import javax.inject.Inject;

class BeanConverterFactory
implements ConverterFactory {
    @Inject
    private BeanManager bm;
    @Inject
    private ConfigRoot root;

    BeanConverterFactory() {
    }

    public <T> ConfigConverter<T> get(Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class theType = (Class)type;
        if (!theType.isAnnotationPresent(ConfigValue.class)) {
            return null;
        }
        return node -> this.buildType(theType, node.getPath());
    }

    protected <T> Optional<T> buildType(Class<T> type, String path) {
        AnnotatedTypeModifier tmod = AnnotatedTypeModifier.create((AnnotatedType)this.bm.createAnnotatedType(type));
        tmod.type().add((Annotation)new ConfigPrefix.Literal(path));
        Object instance = new Unmanaged(this.bm, type).newInstance().produce().inject().postConstruct().get();
        ConfigProcessor proc = new ConfigProcessor(tmod.get());
        if (proc.values().size() > 0) {
            proc.fields().forEach(f -> ConfigInjectionTarget.inject(this.root, instance, f));
            proc.methods().forEach(m -> ConfigInjectionTarget.inject(this.root, instance, m));
        }
        return Optional.of(instance);
    }
}

