/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.api;

import java.beans.ConstructorProperties;
import java.security.AccessController;
import java.util.ServiceLoader;
import lombok.Generated;

final class Service<T> {
    private final Class<T> type;

    T load() {
        return (T)AccessController.doPrivileged(() -> this.load(this.classLoader()));
    }

    private ClassLoader classLoader() {
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        if (cld == null) {
            cld = this.getClass().getClassLoader();
        }
        return cld;
    }

    private T load(ClassLoader cld) {
        T service = null;
        for (T spi : ServiceLoader.load(this.type, cld)) {
            if (service != null) {
                throw new IllegalStateException("Multiple implementations of " + this.type);
            }
            service = spi;
        }
        if (service == null && cld.getParent() != null) {
            service = this.load(cld.getParent());
        }
        if (service == null) {
            throw new IllegalStateException("No implementation of " + this.type);
        }
        return service;
    }

    @ConstructorProperties(value={"type"})
    @Generated
    public Service(Class<T> type) {
        this.type = type;
    }
}

