/*
 * Decompiled with CFR 0.152.
 */
package ascelion.config.api;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import lombok.Generated;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
public @interface ConfigValue {
    public String value() default "";

    public boolean usePrefix() default true;

    public boolean required() default true;

    public static class Literal
    implements ConfigValue {
        private final String value;
        private final boolean usePrefix;
        private final boolean required;

        public static Builder from(ConfigValue annotation) {
            return new Builder().required(annotation.required()).usePrefix(annotation.usePrefix());
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ConfigValue.class;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public boolean usePrefix() {
            return this.usePrefix;
        }

        @Override
        public boolean required() {
            return this.required;
        }

        @ConstructorProperties(value={"value", "usePrefix", "required"})
        @Generated
        private Literal(String value, boolean usePrefix, boolean required) {
            this.value = value;
            this.usePrefix = usePrefix;
            this.required = required;
        }

        @Override
        @Generated
        public String toString() {
            return "ConfigValue.Literal(value=" + this.value + ", usePrefix=" + this.usePrefix + ", required=" + this.required + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private String value;
            @Generated
            private boolean usePrefix;
            @Generated
            private boolean required;

            @Generated
            Builder() {
            }

            @Generated
            public Builder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public Builder usePrefix(boolean usePrefix) {
                this.usePrefix = usePrefix;
                return this;
            }

            @Generated
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            @Generated
            public Literal build() {
                return new Literal(this.value, this.usePrefix, this.required);
            }

            @Generated
            public String toString() {
                return "ConfigValue.Literal.Builder(value=" + this.value + ", usePrefix=" + this.usePrefix + ", required=" + this.required + ")";
            }
        }
    }
}

