/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

import ar.com.siripo.arcache.ArcacheConfigurationGetInterface;
import ar.com.siripo.arcache.BackendKeyBuilder;
import ar.com.siripo.arcache.CacheGetResult;
import ar.com.siripo.arcache.CacheInvalidationObject;
import ar.com.siripo.arcache.ExpirableCacheObject;
import ar.com.siripo.arcache.UnexpectedObjectType;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CacheGetterTask
implements Future<CacheGetResult> {
    protected final String key;
    protected final ArcacheBackendClient backendClient;
    protected final ArcacheBackendClient invalidationBackendClient;
    protected final BackendKeyBuilder keyBuilder;
    protected final ArcacheConfigurationGetInterface config;
    protected final Random random;
    protected boolean cancelled = false;
    protected boolean done = false;
    protected CacheGetResult valueToReturn;
    protected Future<Object> mainFutureGet;
    protected HashMap<String, Future<Object>> invalidationKeysFutureGets;

    protected CacheGetterTask(String key, ArcacheBackendClient backendClient, ArcacheBackendClient invalidationBackendClient, BackendKeyBuilder keyBuilder, ArcacheConfigurationGetInterface config, Random random) {
        this.key = key;
        this.backendClient = backendClient;
        this.invalidationBackendClient = invalidationBackendClient;
        this.keyBuilder = keyBuilder;
        this.config = config;
        this.random = random;
        this.start();
    }

    private void start() {
        this.mainFutureGet = this.backendClient.asyncGet(this.keyBuilder.createBackendKey(this.key));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.done) {
            return false;
        }
        if (this.mainFutureGet != null) {
            this.mainFutureGet.cancel(mayInterruptIfRunning);
        }
        if (this.invalidationKeysFutureGets != null) {
            for (Future<Object> f : this.invalidationKeysFutureGets.values()) {
                f.cancel(mayInterruptIfRunning);
            }
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public CacheGetResult get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.config.getDefaultOperationTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException toe) {
            throw new ExecutionException(toe);
        }
    }

    @Override
    public CacheGetResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        long startTimeMillis = System.currentTimeMillis();
        return this.doTask(startTimeMillis, timeoutMillis);
    }

    protected synchronized CacheGetResult doTask(long startTimeMillis, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        InvalidatedKey inv;
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.done) {
            return this.valueToReturn;
        }
        long remainingTimeMillis = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
        if (remainingTimeMillis <= 0L) {
            throw new TimeoutException();
        }
        Object rawCachedObject = this.mainFutureGet.get(remainingTimeMillis, TimeUnit.MILLISECONDS);
        if (rawCachedObject == null) {
            this.done = true;
            this.valueToReturn = new CacheGetResult(CacheGetResult.Type.MISS);
            return this.valueToReturn;
        }
        if (!(rawCachedObject instanceof ExpirableCacheObject)) {
            this.done = true;
            this.valueToReturn = new CacheGetResult(CacheGetResult.Type.ERROR, new UnexpectedObjectType(ExpirableCacheObject.class, rawCachedObject.getClass()));
            return this.valueToReturn;
        }
        ExpirableCacheObject cachedObject = (ExpirableCacheObject)rawCachedObject;
        HashMap<String, CacheInvalidationObject> invalidationMap = this.loadInvalidationKeys(cachedObject, startTimeMillis, timeoutMillis);
        CacheGetResult result = new CacheGetResult(CacheGetResult.Type.HIT);
        result.value = cachedObject.value;
        result.storeTimestampMillis = cachedObject.timestampMillis;
        result.invalidationKeys = cachedObject.invalidationKeys;
        if (this.isCachedObjectExpired(cachedObject, startTimeMillis)) {
            result.type = CacheGetResult.Type.EXPIRED;
        }
        if ((inv = this.isCachedObjectInvalidated(cachedObject, invalidationMap, startTimeMillis)) != null) {
            if (inv.hardInvalidation) {
                this.done = true;
                this.valueToReturn = new CacheGetResult(CacheGetResult.Type.MISS);
                return this.valueToReturn;
            }
            result.type = CacheGetResult.Type.INVALIDATED;
            result.invalidatedKey = inv.key;
        }
        this.done = true;
        this.valueToReturn = result;
        return this.valueToReturn;
    }

    protected boolean isCachedObjectExpired(ExpirableCacheObject cachedObject, long currentTimeMillis) {
        double expirationProbability;
        double agems = currentTimeMillis - cachedObject.timestampMillis;
        double expms = cachedObject.expirationTTLMillis;
        double age_normalized = 1.0;
        if (expms > 0.0) {
            age_normalized = agems / expms;
        }
        if ((expirationProbability = this.config.getExpirationProbabilityFunction().getProbability(age_normalized)) <= 0.0) {
            return false;
        }
        if (expirationProbability >= 1.0) {
            return true;
        }
        return expirationProbability > this.random.nextDouble();
    }

    protected HashMap<String, CacheInvalidationObject> loadInvalidationKeys(ExpirableCacheObject cachedObject, long startTimeMillis, long timeoutMillis) throws TimeoutException, InterruptedException, ExecutionException {
        if (cachedObject.invalidationKeys == null || cachedObject.invalidationKeys.length <= 0) {
            return null;
        }
        if (this.invalidationKeysFutureGets == null) {
            this.invalidationKeysFutureGets = new HashMap();
        }
        for (String invkey : cachedObject.invalidationKeys) {
            if (this.invalidationKeysFutureGets.containsKey(invkey)) continue;
            Future fut = this.invalidationBackendClient.asyncGet(this.keyBuilder.createInvalidationBackendKey(invkey));
            this.invalidationKeysFutureGets.put(invkey, fut);
        }
        HashMap<String, CacheInvalidationObject> invMap = new HashMap<String, CacheInvalidationObject>();
        for (String invkey : cachedObject.invalidationKeys) {
            if (this.cancelled) {
                throw new CancellationException();
            }
            long remainingTimeMillis = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
            if (remainingTimeMillis <= 0L) {
                throw new TimeoutException();
            }
            CacheInvalidationObject invObj = this.getsCacheInvalidationObjectFromFuture(this.invalidationKeysFutureGets.get(invkey), remainingTimeMillis);
            invMap.put(invkey, invObj);
        }
        return invMap;
    }

    protected CacheInvalidationObject getsCacheInvalidationObjectFromFuture(Future<Object> future, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        Object rawCachedObject = future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        if (rawCachedObject == null) {
            return null;
        }
        if (!(rawCachedObject instanceof CacheInvalidationObject)) {
            return null;
        }
        return (CacheInvalidationObject)rawCachedObject;
    }

    protected InvalidatedKey isCachedObjectInvalidated(ExpirableCacheObject cachedObject, HashMap<String, CacheInvalidationObject> invalidationMap, long currentTimeMillis) {
        if (invalidationMap == null) {
            return null;
        }
        if (currentTimeMillis - this.config.getTimeMeasurementErrorMillis() < cachedObject.timestampMillis) {
            return null;
        }
        long effectiveStoreTimestampMillis = cachedObject.timestampMillis - this.config.getTimeMeasurementErrorMillis();
        for (String invkey : invalidationMap.keySet()) {
            CacheInvalidationObject invObj = invalidationMap.get(invkey);
            if (invObj == null) continue;
            if (effectiveStoreTimestampMillis <= invObj.lastHardInvalidationTimestampMillis) {
                return new InvalidatedKey(invObj, invkey, true);
            }
            if (effectiveStoreTimestampMillis <= invObj.invalidationTimestampMillis) {
                if (invObj.invalidationWindowMillis <= 0L) {
                    return new InvalidatedKey(invObj, invkey, invObj.isHardInvalidation);
                }
                double invalidTimeMS = invObj.invalidationTimestampMillis - effectiveStoreTimestampMillis;
                double normalizedTimeInsideWindow = invalidTimeMS / (double)invObj.invalidationWindowMillis;
                double invalidationProbability = this.config.getInvalidationProbabilityFunction().getProbability(normalizedTimeInsideWindow);
                if (invalidationProbability >= 1.0 || invalidationProbability > this.random.nextDouble()) {
                    return new InvalidatedKey(invObj, invkey, invObj.isHardInvalidation);
                }
            }
            if (effectiveStoreTimestampMillis > invObj.lastSoftInvalidationTimestampMillis) continue;
            return new InvalidatedKey(invObj, invkey, false);
        }
        return null;
    }

    protected static class InvalidatedKey {
        CacheInvalidationObject cacheInvalidationObject;
        String key;
        boolean hardInvalidation;

        InvalidatedKey(CacheInvalidationObject cacheInvalidationObject, String key, boolean hardInvalidation) {
            this.cacheInvalidationObject = cacheInvalidationObject;
            this.key = key;
            this.hardInvalidation = hardInvalidation;
        }
    }
}

