/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

import ar.com.siripo.arcache.ArcacheClientInterface;
import ar.com.siripo.arcache.BackendKeyBuilder;
import ar.com.siripo.arcache.CacheGetResult;
import ar.com.siripo.arcache.CacheGetterTask;
import ar.com.siripo.arcache.ExpirableCacheObject;
import ar.com.siripo.arcache.InvalidateKeyTask;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import ar.com.siripo.arcache.math.AdjustedExponentialProbabilityFunction;
import ar.com.siripo.arcache.math.ProbabilityFunction;
import ar.com.siripo.arcache.util.DummyFuture;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ArcacheClient
implements ArcacheClientInterface,
BackendKeyBuilder {
    protected long defaultOperationTimeoutMillis = 500L;
    protected long timeMeasurementErrorMillis = 3000L;
    protected long defaultInvalidationWindowMillis = 5000L;
    protected boolean defaultHardInvalidation = true;
    protected String keyNamespace = null;
    protected String keyDelimiter = "|";
    protected String invalidationKeyPrefix = "InvKey";
    protected long defaultExpirationTimeMillis = 3600000L;
    protected long defaultStoredObjectRemovalTimeMillis = 86400000L;
    protected ProbabilityFunction expirationProbabilityFunction;
    protected ProbabilityFunction invalidationProbabilityFunction;
    protected ArcacheBackendClient backendClient;
    protected ArcacheBackendClient userConfiguredInvalidationBackendClient;
    protected ArcacheBackendClient effectiveInvalidationBackendClient;
    protected Random randomGenerator = new Random();

    public ArcacheClient() {
        this.expirationProbabilityFunction = new AdjustedExponentialProbabilityFunction(0.5, 11.0);
        this.invalidationProbabilityFunction = new AdjustedExponentialProbabilityFunction(0.0, 11.0);
    }

    protected ArcacheClient(ArcacheBackendClient backendClient) {
        this();
        this.setBackendClient(backendClient);
    }

    @Override
    public void setBackendClient(ArcacheBackendClient backendClient) {
        this.backendClient = backendClient;
        if (this.userConfiguredInvalidationBackendClient == null) {
            this.effectiveInvalidationBackendClient = backendClient;
        }
    }

    @Override
    public ArcacheBackendClient getBackendClient() {
        return this.backendClient;
    }

    @Override
    public void setInvalidationBackendClient(ArcacheBackendClient invalidationBackendClient) {
        this.userConfiguredInvalidationBackendClient = invalidationBackendClient;
        this.effectiveInvalidationBackendClient = this.userConfiguredInvalidationBackendClient == null ? this.backendClient : this.userConfiguredInvalidationBackendClient;
    }

    @Override
    public ArcacheBackendClient getInvalidationBackendClient() {
        return this.userConfiguredInvalidationBackendClient;
    }

    @Override
    public void setDefaultOperationTimeoutMillis(long timeoutMillis) {
        if (timeoutMillis <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultOperationTimeoutMillis = timeoutMillis;
    }

    @Override
    public long getDefaultOperationTimeoutMillis() {
        return this.defaultOperationTimeoutMillis;
    }

    @Override
    public void setTimeMeasurementErrorMillis(long errorMillis) {
        if (errorMillis < 0L) {
            throw new IllegalArgumentException();
        }
        this.timeMeasurementErrorMillis = errorMillis;
    }

    @Override
    public long getTimeMeasurementErrorMillis() {
        return this.timeMeasurementErrorMillis;
    }

    @Override
    public void setDefaultInvalidationWindowMillis(long windowMillis) {
        if (windowMillis < 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultInvalidationWindowMillis = windowMillis;
    }

    @Override
    public long getDefaultInvalidationWindowMillis() {
        return this.defaultInvalidationWindowMillis;
    }

    @Override
    public void setDefaultHardInvalidation(boolean hardInvalidation) {
        this.defaultHardInvalidation = hardInvalidation;
    }

    @Override
    public boolean getDefaultHardInvalidation() {
        return this.defaultHardInvalidation;
    }

    @Override
    public void setKeyNamespace(String namespace) {
        this.keyNamespace = namespace;
        if ("".equals(this.keyNamespace)) {
            this.keyNamespace = null;
        }
    }

    @Override
    public String getKeyNamespace() {
        return this.keyNamespace;
    }

    @Override
    public void setKeyDelimiter(String keyDelimiter) {
        if (keyDelimiter == null || keyDelimiter.equals("")) {
            throw new IllegalArgumentException("The key delimiter must be a non empty String");
        }
        this.keyDelimiter = keyDelimiter;
    }

    @Override
    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    @Override
    public void setDefaultExpirationTimeMillis(long expirationTimeMillis) {
        if (expirationTimeMillis <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultExpirationTimeMillis = expirationTimeMillis;
    }

    @Override
    public long getDefaultExpirationTimeMillis() {
        return this.defaultExpirationTimeMillis;
    }

    @Override
    public void setDefaultStoredObjectRemovalTimeMillis(long removeTimeMillis) {
        if (removeTimeMillis <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultStoredObjectRemovalTimeMillis = removeTimeMillis;
    }

    @Override
    public long getDefaultStoredObjectRemovalTimeMillis() {
        return this.defaultStoredObjectRemovalTimeMillis;
    }

    @Override
    public void setExpirationProbabilityFunction(ProbabilityFunction expirationProbabilityFunction) {
        this.expirationProbabilityFunction = expirationProbabilityFunction;
    }

    @Override
    public ProbabilityFunction getExpirationProbabilityFunction() {
        return this.expirationProbabilityFunction;
    }

    @Override
    public void setInvalidationProbabilityFunction(ProbabilityFunction invalidationProbabilityFunction) {
        this.invalidationProbabilityFunction = invalidationProbabilityFunction;
    }

    @Override
    public ProbabilityFunction getInvalidationProbabilityFunction() {
        return this.invalidationProbabilityFunction;
    }

    @Override
    public Object get(String key) throws TimeoutException, Exception {
        return this.get(key, this.defaultOperationTimeoutMillis);
    }

    @Override
    public Object get(String key, long timeoutMillis) throws TimeoutException, Exception {
        CacheGetResult cacheGetResult = this.getCacheObject(key, timeoutMillis);
        if (cacheGetResult != null) {
            switch (cacheGetResult.type) {
                case HIT: {
                    return cacheGetResult.value;
                }
                case ERROR: 
                case TIMEOUT: {
                    throw cacheGetResult.errorCause;
                }
                case MISS: 
                case EXPIRED: 
                case INVALIDATED: {
                    return null;
                }
            }
        }
        throw new IllegalStateException("Unhandled cacheResultType");
    }

    @Override
    public CacheGetResult getCacheObject(String key) {
        return this.getCacheObject(key, this.defaultOperationTimeoutMillis);
    }

    @Override
    public CacheGetResult getCacheObject(String key, long timeoutMillis) {
        try {
            Future<CacheGetResult> getFuture = this.asyncGetCacheObject(key);
            CacheGetResult r = getFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (r == null) {
                throw new NullPointerException();
            }
            return r;
        }
        catch (TimeoutException tx) {
            CacheGetResult err = new CacheGetResult(CacheGetResult.Type.TIMEOUT, tx);
            return err;
        }
        catch (ExecutionException ee) {
            CacheGetResult err = ee.getCause() instanceof Exception ? new CacheGetResult(CacheGetResult.Type.ERROR, (Exception)ee.getCause()) : new CacheGetResult(CacheGetResult.Type.ERROR, ee);
            return err;
        }
        catch (Exception e) {
            CacheGetResult err = new CacheGetResult(CacheGetResult.Type.ERROR, e);
            return err;
        }
    }

    @Override
    public Future<CacheGetResult> asyncGetCacheObject(String key) {
        try {
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException();
            }
            return this.buildCacheGetterTask(key);
        }
        catch (Exception e) {
            return DummyFuture.createWithException((Exception)e);
        }
    }

    protected Future<CacheGetResult> buildCacheGetterTask(String key) {
        return new CacheGetterTask(key, this.backendClient, this.effectiveInvalidationBackendClient, this, this, this.randomGenerator);
    }

    @Override
    public void set(String key, Object value) throws TimeoutException, Exception {
        this.set(key, value, null);
    }

    @Override
    public void set(String key, Object value, String[] invalidationKeys) throws TimeoutException, Exception {
        Future<Boolean> future = this.asyncSet(key, value, invalidationKeys);
        try {
            future.get(this.defaultOperationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof Exception) {
                throw (Exception)ee.getCause();
            }
            throw ee;
        }
    }

    @Override
    public Future<Boolean> asyncSet(String key, Object value) {
        return this.asyncSet(key, value, null);
    }

    @Override
    public Future<Boolean> asyncSet(String key, Object value, String[] invalidationKeys) {
        try {
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException();
            }
            ExpirableCacheObject expObj = new ExpirableCacheObject();
            expObj.timestampMillis = System.currentTimeMillis();
            expObj.value = value;
            expObj.invalidationKeys = invalidationKeys;
            expObj.expirationTTLMillis = this.defaultExpirationTimeMillis;
            String backendKey = this.createBackendKey(key);
            return this.backendClient.asyncSet(backendKey, this.defaultStoredObjectRemovalTimeMillis, (Object)expObj);
        }
        catch (Exception e) {
            return DummyFuture.createWithException((Exception)e);
        }
    }

    @Override
    public void invalidateKey(String key) throws TimeoutException, Exception {
        this.invalidateKey(key, this.defaultInvalidationWindowMillis);
    }

    @Override
    public void invalidateKey(String key, long invalidationWindowMillis) throws TimeoutException, Exception {
        this.invalidateKey(key, this.defaultHardInvalidation, invalidationWindowMillis);
    }

    @Override
    public void invalidateKey(String key, boolean hardInvalidation) throws TimeoutException, Exception {
        this.invalidateKey(key, hardInvalidation, this.defaultInvalidationWindowMillis);
    }

    @Override
    public void invalidateKey(String key, boolean hardInvalidation, long invalidationWindowMillis) throws TimeoutException, Exception {
        Future<Boolean> future = this.asyncInvalidateKey(key, hardInvalidation, invalidationWindowMillis);
        try {
            future.get(this.defaultOperationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof Exception) {
                throw (Exception)ee.getCause();
            }
            throw ee;
        }
    }

    @Override
    public Future<Boolean> asyncInvalidateKey(String key, boolean hardInvalidation, long invalidationWindowMillis) {
        try {
            if (invalidationWindowMillis < 0L) {
                throw new IllegalArgumentException();
            }
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException();
            }
            return this.buildInvalidateKeyTask(key, hardInvalidation, invalidationWindowMillis);
        }
        catch (Exception e) {
            return DummyFuture.createWithException((Exception)e);
        }
    }

    protected Future<Boolean> buildInvalidateKeyTask(String key, boolean hardInvalidation, long invalidationWindowMillis) {
        return new InvalidateKeyTask(key, hardInvalidation, invalidationWindowMillis, this.effectiveInvalidationBackendClient, this, this);
    }

    @Override
    public String createBackendKey(String userKey) {
        if (this.keyNamespace == null) {
            return userKey;
        }
        return this.keyNamespace + this.keyDelimiter + userKey;
    }

    @Override
    public String createInvalidationBackendKey(String invalidationKey) {
        return this.createBackendKey(this.invalidationKeyPrefix + this.keyDelimiter + invalidationKey);
    }
}

