/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

import ar.com.siripo.arcache.ArcacheConfigurationGetInterface;
import ar.com.siripo.arcache.BackendKeyBuilder;
import ar.com.siripo.arcache.CacheGetResult;
import ar.com.siripo.arcache.CacheInvalidationObject;
import ar.com.siripo.arcache.ExpirableCacheObject;
import ar.com.siripo.arcache.UnexpectedObjectType;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CacheGetterTask
implements Future<CacheGetResult> {
    protected final String key;
    protected final ArcacheBackendClient backendClient;
    protected final BackendKeyBuilder keyBuilder;
    protected final ArcacheConfigurationGetInterface config;
    protected final Random random;
    protected boolean cancelled = false;
    protected boolean done = false;
    protected CacheGetResult valueToReturn;
    protected ExecutionException exceptionToThrow;
    protected Future<Object> mainFutureGet;
    protected HashMap<String, Future<Object>> invalidationKeysFutureGets;

    protected CacheGetterTask(String key, ArcacheBackendClient backendClient, BackendKeyBuilder keyBuilder, ArcacheConfigurationGetInterface config, Random random) {
        this.key = key;
        this.backendClient = backendClient;
        this.keyBuilder = keyBuilder;
        this.config = config;
        this.random = random;
        this.start();
    }

    private void start() {
        this.mainFutureGet = this.backendClient.asyncGet(this.keyBuilder.createBackendKey(this.key));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.done) {
            return false;
        }
        if (this.mainFutureGet != null) {
            this.mainFutureGet.cancel(mayInterruptIfRunning);
        }
        if (this.invalidationKeysFutureGets != null) {
            for (Future<Object> f : this.invalidationKeysFutureGets.values()) {
                f.cancel(mayInterruptIfRunning);
            }
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public CacheGetResult get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.config.getDefaultOperationTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException toe) {
            throw new ExecutionException(toe);
        }
    }

    @Override
    public CacheGetResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        long startTimeMillis = System.currentTimeMillis();
        return this.doTask(startTimeMillis, timeoutMillis);
    }

    protected synchronized CacheGetResult doTask(long startTimeMillis, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        InvalidatedKey inv;
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.done) {
            if (this.exceptionToThrow != null) {
                throw this.exceptionToThrow;
            }
            return this.valueToReturn;
        }
        long remainingTime = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
        if (remainingTime <= 0L) {
            throw new TimeoutException();
        }
        Object rawCachedObject = this.mainFutureGet.get(remainingTime, TimeUnit.MILLISECONDS);
        if (rawCachedObject == null) {
            this.done = true;
            this.valueToReturn = new CacheGetResult(CacheGetResult.Type.MISS);
            return this.valueToReturn;
        }
        if (!(rawCachedObject instanceof ExpirableCacheObject)) {
            this.done = true;
            this.valueToReturn = new CacheGetResult(CacheGetResult.Type.ERROR, new UnexpectedObjectType(ExpirableCacheObject.class, rawCachedObject.getClass()));
            return this.valueToReturn;
        }
        ExpirableCacheObject cachedObject = (ExpirableCacheObject)rawCachedObject;
        HashMap<String, CacheInvalidationObject> invalidationMap = this.loadInvalidationKeys(cachedObject, startTimeMillis, timeoutMillis);
        CacheGetResult result = new CacheGetResult(CacheGetResult.Type.HIT);
        result.value = cachedObject.value;
        result.storeTimestamp = cachedObject.timestamp;
        result.invalidationKeys = cachedObject.invalidationKeys;
        if (this.isCachedObjectExpired(cachedObject, startTimeMillis)) {
            result.type = CacheGetResult.Type.EXPIRED;
        }
        if ((inv = this.isCachedObjectInvalidated(cachedObject, invalidationMap, startTimeMillis)) != null) {
            if (inv.hardInvalidation) {
                this.done = true;
                this.valueToReturn = new CacheGetResult(CacheGetResult.Type.MISS);
                return this.valueToReturn;
            }
            result.type = CacheGetResult.Type.INVALIDATED;
            result.invalidatedByKey = inv.key;
        }
        this.done = true;
        this.valueToReturn = result;
        return this.valueToReturn;
    }

    protected boolean isCachedObjectExpired(ExpirableCacheObject cachedObject, long currentTimeMillis) {
        double invalidationZoneWidth;
        double ageInZone;
        double expirationProbability;
        long age = currentTimeMillis / 1000L - cachedObject.timestamp;
        if (age >= cachedObject.maxTTLSecs) {
            return true;
        }
        return age > cachedObject.minTTLSecs && cachedObject.minTTLSecs < cachedObject.maxTTLSecs && (expirationProbability = (ageInZone = (double)(age - cachedObject.minTTLSecs)) / (invalidationZoneWidth = (double)(cachedObject.maxTTLSecs - cachedObject.minTTLSecs))) > this.random.nextDouble();
    }

    protected HashMap<String, CacheInvalidationObject> loadInvalidationKeys(ExpirableCacheObject cachedObject, long startTimeMillis, long timeoutMillis) throws TimeoutException, InterruptedException, ExecutionException {
        if (cachedObject.invalidationKeys == null || cachedObject.invalidationKeys.length <= 0) {
            return null;
        }
        if (this.invalidationKeysFutureGets == null) {
            this.invalidationKeysFutureGets = new HashMap();
        }
        for (String invkey : cachedObject.invalidationKeys) {
            if (this.invalidationKeysFutureGets.containsKey(invkey)) continue;
            Future fut = this.backendClient.asyncGet(this.keyBuilder.createInvalidationBackendKey(invkey));
            this.invalidationKeysFutureGets.put(invkey, fut);
        }
        HashMap<String, CacheInvalidationObject> invMap = new HashMap<String, CacheInvalidationObject>();
        while (invMap.size() < this.invalidationKeysFutureGets.size()) {
            String invkey;
            if (this.cancelled) {
                throw new CancellationException();
            }
            long remainingTime = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
            if (remainingTime <= 0L) {
                throw new TimeoutException();
            }
            invkey = null;
            for (String itkey : this.invalidationKeysFutureGets.keySet()) {
                if (invMap.containsKey(itkey)) continue;
                invkey = itkey;
                break;
            }
            CacheInvalidationObject invObj = this.getsCacheInvalidationObjectFromFuture(this.invalidationKeysFutureGets.get(invkey), remainingTime);
            invMap.put(invkey, invObj);
        }
        return invMap;
    }

    protected CacheInvalidationObject getsCacheInvalidationObjectFromFuture(Future<Object> future, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        Object rawCachedObject = future.get(timeout, TimeUnit.MILLISECONDS);
        if (rawCachedObject == null) {
            return null;
        }
        if (!(rawCachedObject instanceof CacheInvalidationObject)) {
            return null;
        }
        return (CacheInvalidationObject)rawCachedObject;
    }

    protected InvalidatedKey isCachedObjectInvalidated(ExpirableCacheObject cachedObject, HashMap<String, CacheInvalidationObject> invalidationMap, long currentTimeMillis) {
        if (invalidationMap == null) {
            return null;
        }
        if (currentTimeMillis / 1000L - this.config.getTimeMeasurementError() <= cachedObject.timestamp) {
            return null;
        }
        long effectiveStoreTimestamp = cachedObject.timestamp - this.config.getTimeMeasurementError();
        for (String invkey : invalidationMap.keySet()) {
            CacheInvalidationObject invObj = invalidationMap.get(invkey);
            if (invObj == null) continue;
            if (effectiveStoreTimestamp <= invObj.lastHardInvalidationTimestamp) {
                return new InvalidatedKey(invObj, invkey, true);
            }
            if (effectiveStoreTimestamp <= invObj.invalidationTimestamp) {
                if (invObj.invalidationWindowSecs <= 0L) {
                    return new InvalidatedKey(invObj, invkey, invObj.isHardInvalidation);
                }
                double invalidTime = invObj.invalidationTimestamp - effectiveStoreTimestamp;
                double normalizedTimeInsideWindow = invalidTime / (double)invObj.invalidationWindowSecs;
                if (normalizedTimeInsideWindow > this.random.nextDouble()) {
                    return new InvalidatedKey(invObj, invkey, invObj.isHardInvalidation);
                }
            }
            if (effectiveStoreTimestamp > invObj.lastSoftInvalidationTimestamp) continue;
            return new InvalidatedKey(invObj, invkey, false);
        }
        return null;
    }

    protected static class InvalidatedKey {
        CacheInvalidationObject cacheInvalidationObject;
        String key;
        boolean hardInvalidation;

        InvalidatedKey(CacheInvalidationObject cacheInvalidationObject, String key, boolean hardInvalidation) {
            this.cacheInvalidationObject = cacheInvalidationObject;
            this.key = key;
            this.hardInvalidation = hardInvalidation;
        }
    }
}

