/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache.backend.speedup;

import ar.com.siripo.arcache.backend.inmemory.ArcacheInMemoryClient;
import ar.com.siripo.arcache.backend.speedup.ArcacheSpeedupClient;
import ar.com.siripo.arcache.backend.speedup.ArcacheSpeedupTracker;
import ar.com.siripo.arcache.backend.speedup.RestoredSpeedupCacheObject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class FutureBackendGetWrapper
implements Future<Object> {
    protected Future<Object> backendFuture;
    protected String key;
    protected ArcacheSpeedupClient speedupClient;
    protected boolean protectAgainstBackendFailures;
    protected ArcacheSpeedupTracker tracker;

    protected FutureBackendGetWrapper(ArcacheSpeedupClient speedupClient, Future<Object> backendFuture, String key, boolean protectAgainstBackendFailures, ArcacheSpeedupTracker tracker) {
        this.backendFuture = backendFuture;
        this.key = key;
        this.speedupClient = speedupClient;
        this.protectAgainstBackendFailures = protectAgainstBackendFailures;
        this.tracker = tracker;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.backendFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.backendFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.backendFuture.isDone();
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        try {
            return this.wrappGetResult(this.backendFuture.get());
        }
        catch (InterruptedException ie) {
            return this.wrappGetInterruptedException(ie);
        }
        catch (ExecutionException ee) {
            return this.wrappGetExecutionException(ee);
        }
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.wrappGetResult(this.backendFuture.get(timeout, unit));
        }
        catch (InterruptedException ie) {
            return this.wrappGetInterruptedException(ie);
        }
        catch (ExecutionException ee) {
            return this.wrappGetExecutionException(ee);
        }
        catch (TimeoutException te) {
            return this.wrappGetTimeoutException(te);
        }
    }

    protected Object wrappGetResult(Object getResult) {
        try {
            ArcacheInMemoryClient dst = this.speedupClient.storeSpeedupCache(this.key, getResult);
            if (dst == this.speedupClient.invalidationKeysCache) {
                this.tracker.trackInvalidationKeysCacheMiss(this.key);
            } else if (dst == this.speedupClient.objectsCache) {
                this.tracker.trackObjectsCacheMiss(this.key);
            } else if (dst == this.speedupClient.missesCache) {
                this.tracker.trackMissesCacheMiss(this.key);
            }
        }
        catch (Exception e) {
            this.tracker.trackException(this.key, e);
        }
        return getResult;
    }

    protected Object wrappGetInterruptedException(InterruptedException cause) throws InterruptedException {
        try {
            return this.doProtection(cause);
        }
        catch (Exception exception) {
            throw cause;
        }
    }

    protected Object wrappGetExecutionException(ExecutionException cause) throws ExecutionException {
        try {
            return this.doProtection(cause);
        }
        catch (Exception exception) {
            throw cause;
        }
    }

    protected Object wrappGetTimeoutException(TimeoutException cause) throws TimeoutException {
        try {
            return this.doProtection(cause);
        }
        catch (Exception exception) {
            throw cause;
        }
    }

    protected Object doProtection(Exception cause) throws Exception {
        RestoredSpeedupCacheObject rsco;
        if (this.protectAgainstBackendFailures && (rsco = this.speedupClient.restoreObjectFromAnySpeedupCache(this.key)) != null) {
            this.tracker.trackBackendGetFailureRecovered(this.key, cause);
            return rsco.speedupCacheObject.cachedObject;
        }
        throw new Exception("No protection available");
    }
}

