/*
 * Decompiled with CFR 0.152.
 */
package ar.com.pluspagos.ppconnector.security;

import ar.com.pluspagos.ppconnector.models.CajaModel;
import ar.com.pluspagos.ppconnector.models.DatosTarjeta;
import ar.com.pluspagos.ppconnector.models.OrderModel;
import ar.com.pluspagos.ppconnector.models.PaymentModel;
import ar.com.pluspagos.ppconnector.models.TokenModel;
import com.google.gson.Gson;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Security;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class Package {
    public static String getPackage(Object body, String phrase) {
        return Package.getPackage(body, phrase, null, false);
    }

    public static String getPackage(Object body, String phrase, String token, boolean optEncript) {
        try {
            BeanUtils.setProperty((Object)body, (String)"hash", (Object)Package.hashString(body));
            if (optEncript) {
                Package.encryptPaymentData(body, token);
            }
            Gson gson = new Gson();
            String bodyString = gson.toJson(body);
            return Package.encryptAES256(bodyString, phrase);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String hashString(Object model) {
        return Package.hashSHA256(model);
    }

    private static String encryptAES256(String body, String phrase) {
        return Package.encryptString(body, phrase);
    }

    private static Object encryptPaymentData(Object body, String token) {
        return Package.encryptData(body, token);
    }

    private static Object encryptData(Object body, String token) {
        String encryptKey = token.substring(12, 20);
        try {
            for (PropertyDescriptor property : PropertyUtils.getPropertyDescriptors(body.getClass())) {
                Object propertyValue = PropertyUtils.getProperty((Object)body, (String)property.getName());
                if (propertyValue == null || !property.getPropertyType().equals(DatosTarjeta.class)) continue;
                for (PropertyDescriptor sonProperty : PropertyUtils.getPropertyDescriptors(propertyValue.getClass())) {
                    Object value;
                    if (sonProperty.getName().equals("email") || !PropertyUtils.isWriteable((Object)propertyValue, (String)sonProperty.getName()) || (value = PropertyUtils.getProperty((Object)propertyValue, (String)sonProperty.getName())) == null) continue;
                    PropertyUtils.setProperty((Object)propertyValue, (String)sonProperty.getName(), (Object)Package.encryptString(value.toString(), encryptKey));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return body;
    }

    private static String hashSHA256(Object model) {
        try {
            List<String> campos;
            String input = "";
            HashMap<String, String> map = new HashMap<String, String>();
            for (PropertyDescriptor propertyInfo : PropertyUtils.getPropertyDescriptors(model.getClass())) {
                if (propertyInfo.getName().equals("class")) continue;
                Object propertyValue = PropertyUtils.getProperty((Object)model, (String)propertyInfo.getName());
                String value = "";
                if (propertyValue == null) continue;
                if (!propertyInfo.getPropertyType().isArray() && !propertyInfo.getPropertyType().equals(DatosTarjeta.class)) {
                    input = input + String.format("%s*", propertyValue.toString());
                    value = String.format("%s*", propertyValue.toString());
                } else if (propertyInfo.getPropertyType().equals(DatosTarjeta.class)) {
                    HashMap<String, String> mapSon = new HashMap<String, String>();
                    String valueSon = "";
                    for (PropertyDescriptor sonProperty : PropertyUtils.getPropertyDescriptors(propertyValue.getClass())) {
                        input = input + String.format("%s*", PropertyUtils.getProperty((Object)propertyValue, (String)sonProperty.getName()).toString());
                        valueSon = String.format("%s*", PropertyUtils.getProperty((Object)propertyValue, (String)sonProperty.getName()).toString());
                        mapSon.put(sonProperty.getName(), valueSon);
                    }
                    List<String> campos2 = Arrays.asList("numeroTarjeta", "titularTarjeta", "codigoTarjeta", "anoVencimiento", "mesVencimiento", "tipoDocumento", "documentoTitular", "fechaNacimientoTitular", "numeroPuertaResumen", "email");
                    value = Package.getStringOrdenado(mapSon, campos2);
                } else if (propertyInfo.getPropertyType().isArray()) {
                    for (int i = 0; i < Array.getLength(propertyValue); ++i) {
                        Object o = Array.get(propertyValue, i);
                        input = input + String.format("%s*", o.toString());
                        value = value + String.format("%s*", o.toString());
                    }
                }
                map.put(propertyInfo.getName(), value);
            }
            if (model.getClass().equals(TokenModel.class)) {
                System.out.println("Orden TokenModel.class ");
                campos = Arrays.asList("comercio", "urlDominio", "productos", "totalOperacion", "sucursalComercio", "transaccionComercioId", "hash", "ip");
                input = Package.getStringOrdenado(map, campos);
            } else if (model.getClass().equals(PaymentModel.class)) {
                System.out.println("Orden PaymentModel.class ");
                input = Package.getStringOrdenadoPaymentModel(map);
            } else if (model.getClass().equals(CajaModel.class)) {
                System.out.println("Caja CajaModel.class");
                campos = Arrays.asList("nombre", "codigo", "sucursalComercioId", "fixedAmount");
                input = Package.getStringOrdenado(map, campos);
            } else if (model.getClass().equals(OrderModel.class)) {
                System.out.printf("Order OrderModel.class", new Object[0]);
                campos = Arrays.asList("idTransaccionInterno", "urlNotificacion", "montoTotal", "productos");
                input = Package.getStringOrdenado(map, campos);
            }
            input = input.substring(0, input.length() - 1);
            System.out.println("String concatenado: " + input);
            byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
            MessageDigest provider = MessageDigest.getInstance("SHA-256");
            byte[] hashedBytes = provider.digest(inputBytes);
            StringBuilder output = new StringBuilder(2 * hashedBytes.length);
            for (byte b : hashedBytes) {
                output.append(String.format("%02X", b).toLowerCase());
            }
            return output.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getStringOrdenado(Map<String, String> map, List<String> camposOrdenados) {
        String s = "";
        for (String campo : camposOrdenados) {
            String p = map.get(campo);
            if (p != null && (p.equals("true*") || p.equals("false*"))) {
                p = Package.ucFirst(p);
            }
            s = s + (p == null ? "" : p);
        }
        return s;
    }

    private static String getStringOrdenadoPaymentModel(Map<String, String> map) {
        String s = "";
        String p = map.get("datosTarjeta");
        s = s + (p == null ? "" : p);
        p = map.get("medioPagoId");
        s = s + (p == null ? "" : p);
        p = map.get("cantidadCuotas");
        s = s + (p == null ? "" : p);
        p = map.get("aceptaHabeasData");
        s = s + (p == null ? "" : Package.ucFirst(p));
        p = map.get("aceptTerminosyCondiciones");
        s = s + (p == null ? "" : Package.ucFirst(p));
        p = map.get("ipCliente");
        s = s + (p == null ? "" : p);
        p = map.get("hash");
        s = s + (p == null ? "" : p);
        return s;
    }

    public static String ucFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String encryptString(String plainText, String phrase) {
        try {
            while (phrase.length() < 32) {
                phrase = phrase + phrase;
            }
            phrase = phrase.substring(0, 32);
            byte[] ba = phrase.getBytes("utf-8");
            Security.setProperty("crypto.policy", "unlimited");
            SecretKeySpec key = new SecretKeySpec(ba, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, key);
            byte[] iv = cipher.getIV();
            byte[] encrypted = cipher.doFinal(plainText.getBytes("utf-8"));
            byte[] combinedIvCt = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, combinedIvCt, 0, iv.length);
            System.arraycopy(encrypted, 0, combinedIvCt, iv.length, encrypted.length);
            System.out.println("Encriptado del body: " + Base64.getEncoder().encodeToString(combinedIvCt) + " con la key " + phrase + ".");
            return Base64.getEncoder().encodeToString(combinedIvCt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

