/*
 * Decompiled with CFR 0.152.
 */
package ar.com.pluspagos.ppconnector.clients;

import ar.com.pluspagos.ppconnector.Ambiente;
import ar.com.pluspagos.ppconnector.models.AuthenticationModel;
import ar.com.pluspagos.ppconnector.services.Cajas;
import ar.com.pluspagos.ppconnector.services.HealthChecks;
import ar.com.pluspagos.ppconnector.services.Orders;
import ar.com.pluspagos.ppconnector.services.Payments;
import ar.com.pluspagos.ppconnector.services.Querys;
import ar.com.pluspagos.ppconnector.services.Tokens;
import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class RestClient {
    private static String accessToken;
    private static Ambiente ambiente;
    private static AuthenticationModel authenticationModel;
    private static Retrofit retrofit;
    private static HealthChecks healthChecks;
    private static Tokens tokens;
    private static Payments payments;
    private static Querys querys;
    private static Cajas cajas;
    private static Orders orders;

    public static void init(Ambiente ambiente, String guid, String frase) {
        authenticationModel = AuthenticationModel.with(guid, frase);
        RestClient.ambiente = ambiente;
    }

    private static Retrofit get() {
        if (retrofit == null) {
            if (ambiente == null) {
                throw new IllegalStateException("Connector no inicializado. Falta llamar a PPConnector.init()");
            }
            TokenAuthenticator authenticator = new TokenAuthenticator();
            OkHttpClient client = new OkHttpClient.Builder().authenticator((Authenticator)authenticator).build();
            retrofit = new Retrofit.Builder().client(client).baseUrl(ambiente.getEndpoint()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            authenticator.setRetrofit(retrofit);
        }
        return retrofit;
    }

    public static String getAccessToken() {
        return accessToken;
    }

    public static HealthChecks getHealthChecks() {
        if (healthChecks == null) {
            healthChecks = (HealthChecks)RestClient.get().create(HealthChecks.class);
        }
        return healthChecks;
    }

    public static Tokens getTokens() {
        if (tokens == null) {
            tokens = (Tokens)RestClient.get().create(Tokens.class);
        }
        return tokens;
    }

    public static Payments getPayments() {
        if (payments == null) {
            payments = (Payments)RestClient.get().create(Payments.class);
        }
        return payments;
    }

    public static Querys getQuerys() {
        if (querys == null) {
            querys = (Querys)RestClient.get().create(Querys.class);
        }
        return querys;
    }

    public static Cajas getCajas() {
        if (cajas == null) {
            cajas = (Cajas)RestClient.get().create(Cajas.class);
        }
        return cajas;
    }

    public static Orders getOrders() {
        if (orders == null) {
            orders = (Orders)RestClient.get().create(Orders.class);
        }
        return orders;
    }

    private static class TokenAuthenticator
    implements Authenticator {
        private Retrofit retrofit;

        private TokenAuthenticator() {
        }

        public void setRetrofit(Retrofit retrofit) {
            this.retrofit = retrofit;
        }

        public Request authenticate(Route route, Response response) throws IOException {
            if (authenticationModel == null) {
                throw new IllegalStateException("Connector no inicializado. Falta llamar a PPConnector.init()");
            }
            retrofit2.Response tokenResponse = ((Tokens)this.retrofit.create(Tokens.class)).getAuthenticationToken(authenticationModel).execute();
            if (tokenResponse.code() == 200) {
                accessToken = ((ar.com.pluspagos.ppconnector.models.Response)tokenResponse.body()).getData();
                return response.request().newBuilder().header("Authorization", "Bearer " + accessToken).build();
            }
            return null;
        }
    }
}

