/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.pixels.CompressorStream;
import ar.com.hjg.pngj.pixels.DeflaterEstimatorLz4;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class CompressorStreamLz4
extends CompressorStream {
    private final DeflaterEstimatorLz4 lz4 = new DeflaterEstimatorLz4();
    private byte[] buf;
    private final int buffer_size;
    private int inbuf = 0;
    private static final int MAX_BUFFER_SIZE = 16000;

    public CompressorStreamLz4(OutputStream os, int maxBlockLen, long totalLen) {
        super(os, maxBlockLen, totalLen);
        this.buffer_size = (int)(totalLen > 16000L ? 16000L : totalLen);
    }

    public CompressorStreamLz4(OutputStream os, int maxBlockLen, long totalLen, Deflater def) {
        this(os, maxBlockLen, totalLen);
    }

    public CompressorStreamLz4(OutputStream os, int maxBlockLen, long totalLen, int deflaterCompLevel, int deflaterStrategy) {
        this(os, maxBlockLen, totalLen);
    }

    public void mywrite(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        if (this.done || this.closed) {
            throw new PngjOutputException("write beyond end of stream");
        }
        this.bytesIn += (long)len;
        while (len > 0) {
            int len1;
            if (this.inbuf == 0 && (len >= 16000 || this.bytesIn == this.totalbytes)) {
                this.bytesOut += (long)this.lz4.compressEstim(b, off, len);
                len = 0;
                continue;
            }
            if (this.buf == null) {
                this.buf = new byte[this.buffer_size];
            }
            int n = len1 = this.inbuf + len <= this.buffer_size ? len : this.buffer_size - this.inbuf;
            if (len1 > 0) {
                System.arraycopy(b, off, this.buf, this.inbuf, len1);
            }
            this.inbuf += len1;
            len -= len1;
            off += len1;
            if (this.inbuf != this.buffer_size) continue;
            this.compressFromBuffer();
        }
    }

    void compressFromBuffer() {
        if (this.inbuf > 0) {
            this.bytesOut += (long)this.lz4.compressEstim(this.buf, 0, this.inbuf);
            this.inbuf = 0;
        }
    }

    public void done() {
        if (!this.done) {
            this.compressFromBuffer();
            this.done = true;
            this.flush();
        }
    }

    public void close() {
        this.done();
        if (!this.closed) {
            super.close();
            this.buf = null;
        }
    }

    public void reset() {
        this.done();
        super.reset();
    }
}

