/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class DataSetFactory {
    public static JRDesignChartDataset getDataset(byte chartType, JRDesignGroup group, JRDesignGroup parentGroup, JRDesignVariable var) {
        JRDesignChartDataset dataSet = null;
        if (chartType == 9) {
            dataSet = DataSetFactory.createPieDataset(group, parentGroup, var);
        } else if (chartType == 3) {
            dataSet = DataSetFactory.createBarDataset(group, parentGroup, var);
        }
        return dataSet;
    }

    private static JRDesignChartDataset createBarDataset(JRDesignGroup group, JRDesignGroup parentGroup, JRDesignVariable var) {
        JRDesignCategoryDataset data = new JRDesignCategoryDataset(null);
        JRDesignCategorySeries serie = new JRDesignCategorySeries();
        serie.setValueExpression(DataSetFactory.getExpressionFromVariable(var));
        JRExpression exp2 = group.getExpression();
        serie.setCategoryExpression(exp2);
        serie.setLabelExpression(exp2);
        serie.setSeriesExpression(exp2);
        data.addCategorySeries((JRCategorySeries)serie);
        DataSetFactory.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    private static JRDesignChartDataset createPieDataset(JRDesignGroup group, JRDesignGroup parentGroup, JRDesignVariable var) {
        JRDesignPieDataset data = new JRDesignPieDataset(null);
        data.setValueExpression(DataSetFactory.getExpressionFromVariable(var));
        data.setKeyExpression(group.getExpression());
        DataSetFactory.setResetStyle((JRDesignChartDataset)data, group, parentGroup);
        return data;
    }

    private static JRExpression getExpressionFromVariable(JRDesignVariable var) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("$V{" + var.getName() + "}");
        exp.setValueClass(var.getValueClass());
        return exp;
    }

    private static void setResetStyle(JRDesignChartDataset dataset, JRDesignGroup group, JRDesignGroup parentGroup) {
        dataset.setResetGroup((JRGroup)parentGroup);
        if (dataset.getResetGroup().equals(group)) {
            dataset.setResetType((byte)1);
        } else {
            dataset.setResetType((byte)4);
        }
    }
}

