/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.ColumnRegistrationManager;
import ar.com.fdvs.dj.core.registration.ColumnsGroupRegistrationManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.ColumnsGroup;
import ar.com.fdvs.dj.domain.entities.Parameter;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.util.DJCompilerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DynamicJasperHelper {
    private static final Log log = LogFactory.getLog((Class)DynamicJasperHelper.class);
    private static final String DJ_RESOURCE_BUNDLE = "dj-messages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void registerEntities(DynamicJasperDesign jd, DynamicReport dr) {
        new ColumnRegistrationManager(jd, dr).registerEntities(dr.getColumns());
        new ColumnsGroupRegistrationManager(jd, dr).registerEntities(dr.getColumnsGroups());
        DynamicJasperHelper.registerOtherFields(jd, dr.getFields());
        Locale locale = dr.getReportLocale() == null ? Locale.getDefault() : dr.getReportLocale();
        ResourceBundle messages = null;
        if (dr.getResourceBundle() != null) {
            try {
                messages = ResourceBundle.getBundle(dr.getResourceBundle(), locale);
            }
            catch (MissingResourceException e) {
                log.warn((Object)(e.getMessage() + ", usign defaut (dj-messages)"));
            }
        }
        if (messages == null) {
            try {
                messages = ResourceBundle.getBundle(DJ_RESOURCE_BUNDLE, locale);
            }
            catch (MissingResourceException e) {
                log.warn((Object)(e.getMessage() + ", usign defaut (dj-messages)"));
            }
            finally {
                messages = ResourceBundle.getBundle(DJ_RESOURCE_BUNDLE, Locale.ENGLISH);
            }
        }
        jd.getParametersWithValues().put("REPORT_RESOURCE_BUNDLE", messages);
        jd.getParametersWithValues().put("REPORT_LOCALE", locale);
    }

    private static void registerOtherFields(DynamicJasperDesign jd, List fields) {
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            ColumnProperty element = (ColumnProperty)iter.next();
            JRDesignField field = new JRDesignField();
            field.setValueClassName(element.getValueClassName());
            field.setName(element.getProperty());
            try {
                jd.addField((JRField)field);
            }
            catch (JRException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static DynamicJasperDesign getNewDesign(DynamicReport dr) {
        log.info((Object)"obtaining DynamicJasperDesign instance");
        DynamicJasperDesign des = new DynamicJasperDesign();
        DynamicReportOptions options = dr.getOptions();
        Page page = options.getPage();
        des.setColumnCount(options.getColumnsPerPage());
        des.setPrintOrder((byte)1);
        des.setPageWidth(page.getWidth());
        des.setPageHeight(page.getHeight());
        des.setColumnWidth(options.getColumnWidth());
        des.setColumnSpacing(options.getColumnSpace());
        des.setLeftMargin(options.getLeftMargin());
        des.setRightMargin(options.getRightMargin());
        des.setTopMargin(options.getTopMargin());
        des.setBottomMargin(options.getBottomMargin());
        des.setWhenNoDataType(dr.getWhenNoDataType());
        des.setWhenResourceMissingType(dr.getWhenResourceMissing());
        des.setTitleNewPage(false);
        des.setSummaryNewPage(false);
        des.setDetail((JRBand)new JRDesignBand());
        des.getDetail().setSplitAllowed(dr.isAllowDetailSplit());
        des.setPageHeader((JRBand)new JRDesignBand());
        des.setPageFooter((JRBand)new JRDesignBand());
        des.setSummary((JRBand)new JRDesignBand());
        des.setTitleNewPage(options.isTitleNewPage());
        des.setIgnorePagination(options.isIgnorePagination());
        if (dr.getQuery() != null) {
            JRDesignQuery query = DynamicJasperHelper.getJRDesignQuery(dr);
            des.setQuery(query);
        }
        des.setName("DynamicReport");
        return des;
    }

    protected static DynamicJasperDesign generateJasperDesign(DynamicReport dr) throws CoreException {
        DynamicJasperDesign jd = null;
        try {
            if (dr.getTemplateFileName() != null) {
                log.info((Object)("loading template file: " + dr.getTemplateFileName()));
                log.info((Object)"Attemping to find the file directly in the file system...");
                File file = new File(dr.getTemplateFileName());
                if (file.exists()) {
                    JasperDesign jdesign = JRXmlLoader.load((File)file);
                    jd = DynamicJasperHelper.downCast(jdesign);
                } else {
                    log.info((Object)"Not found: Attemping to find the file in the classpath...");
                    URL url = DynamicJasperHelper.class.getClassLoader().getResource(dr.getTemplateFileName());
                    JasperDesign jdesign = JRXmlLoader.load((InputStream)url.openStream());
                    jd = DynamicJasperHelper.downCast(jdesign);
                }
                DynamicJasperHelper.populateReportOptionsFromDesign(jd, dr);
            } else {
                jd = DynamicJasperHelper.getNewDesign(dr);
            }
            DynamicJasperHelper.registerParameters(jd, dr);
        }
        catch (JRException e) {
            throw new CoreException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CoreException(e.getMessage(), e);
        }
        return jd;
    }

    protected static void registerParameters(DynamicJasperDesign jd, DynamicReport dr) {
        Iterator iterator = dr.getParameters().iterator();
        while (iterator.hasNext()) {
            Parameter param = (Parameter)iterator.next();
            JRDesignParameter jrparam = new JRDesignParameter();
            jrparam.setName(param.getName());
            jrparam.setValueClassName(param.getClassName());
            try {
                jd.addParameter((JRParameter)jrparam);
            }
            catch (JRException e) {
                throw new CoreException(e.getMessage(), e);
            }
        }
    }

    protected static void populateReportOptionsFromDesign(DynamicJasperDesign jd, DynamicReport dr) {
        DynamicReportOptions options = dr.getOptions();
        options.setBottomMargin(new Integer(jd.getBottomMargin()));
        options.setTopMargin(new Integer(jd.getTopMargin()));
        options.setLeftMargin(new Integer(jd.getLeftMargin()));
        options.setRightMargin(new Integer(jd.getRightMargin()));
        options.setColumnSpace(new Integer(jd.getColumnSpacing()));
        options.setColumnsPerPage(new Integer(jd.getColumnCount()));
        options.setPage(new Page(jd.getPageHeight(), jd.getPageWidth()));
        if (dr.getQuery() != null) {
            JRDesignQuery query = DynamicJasperHelper.getJRDesignQuery(dr);
            jd.setQuery(query);
        }
    }

    private static JRDesignQuery getJRDesignQuery(DynamicReport dr) {
        JRDesignQuery query = new JRDesignQuery();
        query.setText(dr.getQuery().getText());
        query.setLanguage(dr.getQuery().getLanguage());
        return query;
    }

    protected static DynamicJasperDesign downCast(JasperDesign jd) throws CoreException {
        DynamicJasperDesign djd = new DynamicJasperDesign();
        log.info((Object)"downcasting JasperDesign");
        try {
            BeanUtils.copyProperties((Object)((Object)djd), (Object)jd);
            Iterator iter = jd.getParametersList().iterator();
            while (iter.hasNext()) {
                JRParameter element = (JRParameter)iter.next();
                try {
                    djd.addParameter(element);
                }
                catch (JRException e) {}
            }
            Iterator iterator = jd.getStylesList().iterator();
            while (iterator.hasNext()) {
                JRStyle style = (JRStyle)iterator.next();
                try {
                    djd.addStyle(style);
                }
                catch (JRException e) {
                    log.warn((Object)("Duplicated style (style name \"" + style.getName() + "\") when loading design: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new CoreException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new CoreException(e.getMessage());
        }
        return djd;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, JRDataSource ds) throws JRException {
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, ds, new HashMap());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Collection collection) throws JRException {
        JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collection);
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, (JRDataSource)ds, new HashMap());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, ResultSet resultSet) throws JRException {
        JRResultSetDataSource ds = new JRResultSetDataSource(resultSet);
        return DynamicJasperHelper.generateJasperPrint(dr, layoutManager, (JRDataSource)ds, new HashMap());
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, JRDataSource ds, Map _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperPrint jp = null;
        if (_parameters == null) {
            _parameters = new HashMap();
        }
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap params = new HashMap();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        jp = JasperFillManager.fillReport((JasperReport)jr, params, (JRDataSource)ds);
        return jp;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Connection con, Map _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperPrint jp = null;
        if (_parameters == null) {
            _parameters = new HashMap();
        }
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap params = new HashMap();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        jp = JasperFillManager.fillReport((JasperReport)jr, params, (Connection)con);
        return jp;
    }

    public static JasperPrint generateJasperPrint(DynamicReport dr, LayoutManager layoutManager, Map _parameters) throws JRException {
        log.info((Object)"generating JasperPrint");
        JasperPrint jp = null;
        if (_parameters == null) {
            _parameters = new HashMap();
        }
        DynamicJasperHelper.compileOrLoadSubreports(dr, _parameters);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        HashMap params = new HashMap();
        if (!_parameters.isEmpty()) {
            DynamicJasperHelper.registerParams(jd, _parameters);
            params.putAll(_parameters);
        }
        DynamicJasperHelper.registerEntities(jd, dr);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)DJCompilerFactory.getCompilerClassName());
        JasperReport jr = JasperCompileManager.compileReport((JasperDesign)jd);
        params.putAll(jd.getParametersWithValues());
        jp = JasperFillManager.fillReport((JasperReport)jr, params);
        return jp;
    }

    public static String generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = "UTF-8";
        }
        return JRXmlWriter.writeReport((JRReport)jr, (String)xmlEncoding);
    }

    public static void generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding, OutputStream outputStream) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = "UTF-8";
        }
        JRXmlWriter.writeReport((JRReport)jr, (OutputStream)outputStream, (String)xmlEncoding);
    }

    public static void generateJRXML(DynamicReport dr, LayoutManager layoutManager, Map _parameters, String xmlEncoding, String filename) throws JRException {
        JasperReport jr = DynamicJasperHelper.generateJasperReport(dr, layoutManager, _parameters);
        if (xmlEncoding == null) {
            xmlEncoding = "UTF-8";
        }
        JRXmlWriter.writeReport((JRReport)jr, (String)filename, (String)xmlEncoding);
    }

    protected static void compileOrLoadSubreports(DynamicReport dr, Map _parameters) throws JRException {
        Iterator iterator = dr.getColumnsGroups().iterator();
        while (iterator.hasNext()) {
            JasperReport jp;
            Subreport subreport;
            ColumnsGroup group = (ColumnsGroup)iterator.next();
            Iterator iterator2 = group.getHeaderSubreports().iterator();
            while (iterator2.hasNext()) {
                subreport = (Subreport)iterator2.next();
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.compileOrLoadSubreports(subreport.getDynamicReport(), _parameters);
                jp = DynamicJasperHelper.generateJasperReport(subreport.getDynamicReport(), subreport.getLayoutManager(), _parameters);
                _parameters.put(jp.toString(), jp);
                subreport.setReport(jp);
            }
            iterator2 = group.getFooterSubreports().iterator();
            while (iterator2.hasNext()) {
                subreport = (Subreport)iterator2.next();
                if (subreport.getDynamicReport() == null) continue;
                DynamicJasperHelper.compileOrLoadSubreports(subreport.getDynamicReport(), _parameters);
                jp = DynamicJasperHelper.generateJasperReport(subreport.getDynamicReport(), subreport.getLayoutManager(), _parameters);
                _parameters.put(jp.toString(), jp);
                subreport.setReport(jp);
            }
        }
    }

    public static void registerParams(DynamicJasperDesign jd, Map _parameters) {
        Iterator iterator = _parameters.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!(key instanceof String)) continue;
            try {
                if (jd.getParametersMap().get(key) != null) {
                    log.warn((Object)("Parameter \"" + key + "\" already registered, skipping this one."));
                    continue;
                }
                JRDesignParameter parameter = new JRDesignParameter();
                Object value = _parameters.get(key);
                Class<?> clazz = value.getClass().getComponentType();
                if (clazz == null) {
                    clazz = value.getClass();
                }
                parameter.setValueClass(clazz);
                parameter.setName((String)key);
                jd.addParameter((JRParameter)parameter);
            }
            catch (JRException e) {}
        }
    }

    public static JasperReport generateJasperReport(DynamicReport dr, LayoutManager layoutManager) throws JRException {
        log.info((Object)"generating JasperReport");
        JasperReport jr = null;
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        DynamicJasperHelper.registerEntities(jd, dr);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"ar.com.fdvs.dj.util.DJJRJdtCompiler");
        jr = JasperCompileManager.compileReport((JasperDesign)jd);
        return jr;
    }

    public static final JasperReport generateJasperReport(DynamicReport dr, LayoutManager layoutManager, Map generatedParams) throws JRException {
        log.info((Object)"generating JasperReport");
        JasperReport jr = null;
        if (generatedParams == null) {
            generatedParams = new HashMap();
        }
        DynamicJasperHelper.compileOrLoadSubreports(dr, generatedParams);
        DynamicJasperDesign jd = DynamicJasperHelper.generateJasperDesign(dr);
        DynamicJasperHelper.registerEntities(jd, dr);
        DynamicJasperHelper.registerParams(jd, generatedParams);
        layoutManager.applyLayout(jd, dr);
        JRProperties.setProperty((String)"net.sf.jasperreports.compiler.class", (String)"ar.com.fdvs.dj.util.DJJRJdtCompiler");
        jr = JasperCompileManager.compileReport((JasperDesign)jd);
        generatedParams.putAll(jd.getParametersWithValues());
        return jr;
    }

    public static ColumnsGroup getColumnGroup(AbstractColumn col, List groups) {
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            ColumnsGroup group = (ColumnsGroup)it.next();
            if (!group.getColumnToGroupBy().equals(col)) continue;
            return group;
        }
        return null;
    }

    public static boolean existsGroupWithColumnNames(List groups) {
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            ColumnsGroup group = (ColumnsGroup)it.next();
            if (!group.getLayout().isShowColumnName()) continue;
            return true;
        }
        return false;
    }
}

