package com.apppartner.core.statelistview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.apppartner.core.R;

/**
 * Created by Jonathan Muller on 5/26/16.
 */
public class ErrorStateView extends LinearLayout implements Controllable
{
    public ImageView iconImageView;
    public TextView descriptionTextView;

    public ErrorStateView(Context context)
    {
        super(context);
        init(context);
    }

    public ErrorStateView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(context);
    }

    public ErrorStateView(Context context, AttributeSet attrs, int defStyleAttr)
    {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context)
    {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.default_error_state_view, this, true);

        iconImageView = (ImageView) view.findViewById(R.id.state_imageView);
        descriptionTextView = (TextView) view.findViewById(R.id.state_textView);
    }

    @Override
    public void setImage(int drawableRes)
    {
        iconImageView.setImageResource(drawableRes);
    }

    @Override
    public void setMessage(String message)
    {
        descriptionTextView.setText(message);
    }

    @Override
    public void setClickListener(View.OnClickListener onClickListener)
    {
        descriptionTextView.setOnClickListener(onClickListener);
    }
}
