package com.apppartner.core.statelistview;

import android.view.View;

/**
 * Created by Jonathan Muller on 5/26/16.
 *
 * This interface is used by the StateListView
 *
 * Implement this interface is you want your view to be able to use
 * the helper methods that StateListView provides
 *
 * NOTE: If any new helpers methods are added that manipulate the empty & error states
 * the methods should interact with this interface and any appropriate methods should be added here
 */
public interface Controllable
{
    /**
     * Sets the image to be shown in the StateListView to the drawable resource
     * @param drawableRes
     */
    void setImage(int drawableRes);

    /**
     * Set the message to be shown in the StateListView to the provided message
     * @param message
     */
    void setMessage(String message);

    /**
     * Sets the click listener to be called int the StateListView when a certain
     * part of the implementing view is clicked
     * @param onClickListener
     */
    void setClickListener(View.OnClickListener onClickListener);
}
