package com.apppartner.core.retrofit;

import android.util.Log;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/**
 * Created on 5/6/16.
 *
 * @author Jake Green
 */
public class RetrofitCallback<T> implements Callback<T>
{
    private static final String TAG = "Retrofit";

    public RetrofitResponse<T> retrofitResponse;

    public RetrofitCallback(RetrofitResponse<T> retrofitResponse)
    {
        this.retrofitResponse = retrofitResponse;
    }

    @Override
    public void onResponse(Call<T> call, Response<T> response)
    {
        try
        {
            if (response.errorBody() != null)
            {
                String errorJSON = response.errorBody().string();

                Log.e(TAG, call.request().url().toString() + " Error: " + errorJSON);
                retrofitResponse.onFailure(errorJSON);
            }
            else
            {
                Log.d(TAG, call.request().url().toString() + " Success");
                retrofitResponse.onSuccess(response.body());
            }
        }
        catch (Exception e)
        {
            Log.e(TAG, call.request().url().toString() + " Exception: " + e.getLocalizedMessage());
            retrofitResponse.onFailure(e.getLocalizedMessage());
        }
    }

    @Override
    public void onFailure(Call<T> call, Throwable t)
    {
        if (t != null && t.getMessage() != null)
        {
            Log.e(TAG, call.request().url().toString() + " Failure: " + t.getMessage());
            retrofitResponse.onFailure(t.getMessage());
        }
    }
}