/*
 * Decompiled with CFR 0.152.
 */
package app.visly.io;

import app.visly.io.type.FontStyle;
import app.visly.io.type.Platform;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.InputFieldMarshaller;
import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.api.internal.UnmodifiableMapBuilder;
import com.apollographql.apollo.api.internal.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssetsQuery
implements Query<Data, Data, Variables> {
    public static final String OPERATION_ID = "7c7ae8fe3f238db4d1bd1bf5f589313d83def74ebd8af94a8a7c56772e890d98";
    public static final String QUERY_DOCUMENT = "query Assets($apiToken: String!, $version: String!, $platform: Platform) {\n  team(apiToken: $apiToken) {\n    __typename\n    releaseInfo(version: $version) {\n      __typename\n      components {\n        __typename\n        title\n        vml\n      }\n      colors {\n        __typename\n        name\n        red\n        green\n        blue\n        alpha\n      }\n      images {\n        __typename\n        name\n        versions(platform: $platform) {\n          __typename\n          mimetype\n          base64\n          density\n        }\n      }\n      appStrings {\n        __typename\n        name\n        value\n      }\n      textStyles {\n        __typename\n        name\n        fontSize {\n          __typename\n          value\n          unit\n        }\n        lineHeight {\n          __typename\n          value\n          unit\n        }\n        font {\n          __typename\n          family\n          fontWeight\n          fontStyle\n          fileUrl\n          fileExtension\n        }\n      }\n    }\n  }\n}";
    public static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "Assets";
        }
    };
    private final Variables variables;

    public AssetsQuery(@NotNull String apiToken, @NotNull String version, @NotNull Input<Platform> platform) {
        Utils.checkNotNull((Object)apiToken, (Object)"apiToken == null");
        Utils.checkNotNull((Object)version, (Object)"version == null");
        Utils.checkNotNull(platform, (Object)"platform == null");
        this.variables = new Variables(apiToken, version, platform);
    }

    public String operationId() {
        return OPERATION_ID;
    }

    public String queryDocument() {
        return QUERY_DOCUMENT;
    }

    public Data wrapData(Data data) {
        return data;
    }

    public Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    public static class Font {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"family", (String)"family", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"fontWeight", (String)"fontWeight", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"fontStyle", (String)"fontStyle", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"fileUrl", (String)"fileUrl", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"fileExtension", (String)"fileExtension", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String family;
        @NotNull
        final String fontWeight;
        @NotNull
        final FontStyle fontStyle;
        @NotNull
        final String fileUrl;
        @NotNull
        final String fileExtension;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Font(@NotNull String __typename, @NotNull String family, @NotNull String fontWeight, @NotNull FontStyle fontStyle, @NotNull String fileUrl, @NotNull String fileExtension) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.family = (String)Utils.checkNotNull((Object)family, (Object)"family == null");
            this.fontWeight = (String)Utils.checkNotNull((Object)fontWeight, (Object)"fontWeight == null");
            this.fontStyle = (FontStyle)((Object)Utils.checkNotNull((Object)((Object)fontStyle), (Object)"fontStyle == null"));
            this.fileUrl = (String)Utils.checkNotNull((Object)fileUrl, (Object)"fileUrl == null");
            this.fileExtension = (String)Utils.checkNotNull((Object)fileExtension, (Object)"fileExtension == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String family() {
            return this.family;
        }

        @NotNull
        public String fontWeight() {
            return this.fontWeight;
        }

        @NotNull
        public FontStyle fontStyle() {
            return this.fontStyle;
        }

        @NotNull
        public String fileUrl() {
            return this.fileUrl;
        }

        @NotNull
        public String fileExtension() {
            return this.fileExtension;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], family);
                    writer.writeString($responseFields[2], fontWeight);
                    writer.writeString($responseFields[3], fontStyle.rawValue());
                    writer.writeString($responseFields[4], fileUrl);
                    writer.writeString($responseFields[5], fileExtension);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Font{__typename=" + this.__typename + ", family=" + this.family + ", fontWeight=" + this.fontWeight + ", fontStyle=" + (Object)((Object)this.fontStyle) + ", fileUrl=" + this.fileUrl + ", fileExtension=" + this.fileExtension + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Font) {
                Font that = (Font)o;
                return this.__typename.equals(that.__typename) && this.family.equals(that.family) && this.fontWeight.equals(that.fontWeight) && this.fontStyle.equals((Object)that.fontStyle) && this.fileUrl.equals(that.fileUrl) && this.fileExtension.equals(that.fileExtension);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.family.hashCode();
                h *= 1000003;
                h ^= this.fontWeight.hashCode();
                h *= 1000003;
                h ^= this.fontStyle.hashCode();
                h *= 1000003;
                h ^= this.fileUrl.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.fileExtension.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Font> {
            public Font map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String family = reader.readString($responseFields[1]);
                String fontWeight = reader.readString($responseFields[2]);
                String fontStyleStr = reader.readString($responseFields[3]);
                FontStyle fontStyle = fontStyleStr != null ? FontStyle.safeValueOf(fontStyleStr) : null;
                String fileUrl = reader.readString($responseFields[4]);
                String fileExtension = reader.readString($responseFields[5]);
                return new Font(__typename, family, fontWeight, fontStyle, fileUrl, fileExtension);
            }
        }
    }

    public static class LineHeight {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forDouble((String)"value", (String)"value", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"unit", (String)"unit", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final double value;
        @NotNull
        final String unit;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public LineHeight(@NotNull String __typename, double value, @NotNull String unit) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.value = value;
            this.unit = (String)Utils.checkNotNull((Object)unit, (Object)"unit == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public double value() {
            return this.value;
        }

        @NotNull
        public String unit() {
            return this.unit;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeDouble($responseFields[1], Double.valueOf(value));
                    writer.writeString($responseFields[2], unit);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "LineHeight{__typename=" + this.__typename + ", value=" + this.value + ", unit=" + this.unit + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof LineHeight) {
                LineHeight that = (LineHeight)o;
                return this.__typename.equals(that.__typename) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value) && this.unit.equals(that.unit);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= Double.valueOf(this.value).hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.unit.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<LineHeight> {
            public LineHeight map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                double value = reader.readDouble($responseFields[1]);
                String unit = reader.readString($responseFields[2]);
                return new LineHeight(__typename, value, unit);
            }
        }
    }

    public static class FontSize {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forDouble((String)"value", (String)"value", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"unit", (String)"unit", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        final double value;
        @NotNull
        final String unit;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public FontSize(@NotNull String __typename, double value, @NotNull String unit) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.value = value;
            this.unit = (String)Utils.checkNotNull((Object)unit, (Object)"unit == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        public double value() {
            return this.value;
        }

        @NotNull
        public String unit() {
            return this.unit;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeDouble($responseFields[1], Double.valueOf(value));
                    writer.writeString($responseFields[2], unit);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "FontSize{__typename=" + this.__typename + ", value=" + this.value + ", unit=" + this.unit + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FontSize) {
                FontSize that = (FontSize)o;
                return this.__typename.equals(that.__typename) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value) && this.unit.equals(that.unit);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= Double.valueOf(this.value).hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.unit.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<FontSize> {
            public FontSize map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                double value = reader.readDouble($responseFields[1]);
                String unit = reader.readString($responseFields[2]);
                return new FontSize(__typename, value, unit);
            }
        }
    }

    public static class TextStyle {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"fontSize", (String)"fontSize", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"lineHeight", (String)"lineHeight", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"font", (String)"font", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        @NotNull
        final FontSize fontSize;
        @NotNull
        final LineHeight lineHeight;
        @NotNull
        final Font font;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public TextStyle(@NotNull String __typename, @NotNull String name, @NotNull FontSize fontSize, @NotNull LineHeight lineHeight, @NotNull Font font) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.fontSize = (FontSize)Utils.checkNotNull((Object)fontSize, (Object)"fontSize == null");
            this.lineHeight = (LineHeight)Utils.checkNotNull((Object)lineHeight, (Object)"lineHeight == null");
            this.font = (Font)Utils.checkNotNull((Object)font, (Object)"font == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public FontSize fontSize() {
            return this.fontSize;
        }

        @NotNull
        public LineHeight lineHeight() {
            return this.lineHeight;
        }

        @NotNull
        public Font font() {
            return this.font;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeObject($responseFields[2], fontSize.marshaller());
                    writer.writeObject($responseFields[3], lineHeight.marshaller());
                    writer.writeObject($responseFields[4], font.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "TextStyle{__typename=" + this.__typename + ", name=" + this.name + ", fontSize=" + this.fontSize + ", lineHeight=" + this.lineHeight + ", font=" + this.font + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TextStyle) {
                TextStyle that = (TextStyle)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.fontSize.equals(that.fontSize) && this.lineHeight.equals(that.lineHeight) && this.font.equals(that.font);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                h ^= this.fontSize.hashCode();
                h *= 1000003;
                h ^= this.lineHeight.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.font.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<TextStyle> {
            final FontSize.Mapper fontSizeFieldMapper = new FontSize.Mapper();
            final LineHeight.Mapper lineHeightFieldMapper = new LineHeight.Mapper();
            final Font.Mapper fontFieldMapper = new Font.Mapper();

            public TextStyle map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                FontSize fontSize = (FontSize)reader.readObject($responseFields[2], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<FontSize>(){

                    public FontSize read(ResponseReader reader) {
                        return fontSizeFieldMapper.map(reader);
                    }
                });
                LineHeight lineHeight = (LineHeight)reader.readObject($responseFields[3], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<LineHeight>(){

                    public LineHeight read(ResponseReader reader) {
                        return lineHeightFieldMapper.map(reader);
                    }
                });
                Font font = (Font)reader.readObject($responseFields[4], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Font>(){

                    public Font read(ResponseReader reader) {
                        return fontFieldMapper.map(reader);
                    }
                });
                return new TextStyle(__typename, name, fontSize, lineHeight, font);
            }
        }
    }

    public static class AppString {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"value", (String)"value", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        @NotNull
        final String value;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public AppString(@NotNull String __typename, @NotNull String name, @NotNull String value) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.value = (String)Utils.checkNotNull((Object)value, (Object)"value == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public String value() {
            return this.value;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeString($responseFields[2], value);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "AppString{__typename=" + this.__typename + ", name=" + this.name + ", value=" + this.value + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AppString) {
                AppString that = (AppString)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.value.equals(that.value);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.value.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<AppString> {
            public AppString map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                String value = reader.readString($responseFields[2]);
                return new AppString(__typename, name, value);
            }
        }
    }

    public static class Version {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"mimetype", (String)"mimetype", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"base64", (String)"base64", null, (boolean)false, Collections.emptyList()), ResponseField.forDouble((String)"density", (String)"density", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String mimetype;
        @NotNull
        final String base64;
        final double density;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Version(@NotNull String __typename, @NotNull String mimetype, @NotNull String base64, double density) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.mimetype = (String)Utils.checkNotNull((Object)mimetype, (Object)"mimetype == null");
            this.base64 = (String)Utils.checkNotNull((Object)base64, (Object)"base64 == null");
            this.density = density;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String mimetype() {
            return this.mimetype;
        }

        @NotNull
        public String base64() {
            return this.base64;
        }

        public double density() {
            return this.density;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], mimetype);
                    writer.writeString($responseFields[2], base64);
                    writer.writeDouble($responseFields[3], Double.valueOf(density));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Version{__typename=" + this.__typename + ", mimetype=" + this.mimetype + ", base64=" + this.base64 + ", density=" + this.density + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Version) {
                Version that = (Version)o;
                return this.__typename.equals(that.__typename) && this.mimetype.equals(that.mimetype) && this.base64.equals(that.base64) && Double.doubleToLongBits(this.density) == Double.doubleToLongBits(that.density);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.mimetype.hashCode();
                h *= 1000003;
                h ^= this.base64.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= Double.valueOf(this.density).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Version> {
            public Version map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String mimetype = reader.readString($responseFields[1]);
                String base64 = reader.readString($responseFields[2]);
                double density = reader.readDouble($responseFields[3]);
                return new Version(__typename, mimetype, base64, density);
            }
        }
    }

    public static class Image {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"versions", (String)"versions", (Map)new UnmodifiableMapBuilder(1).put((Object)"platform", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"platform").build()).build(), (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        @NotNull
        final List<Version> versions;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Image(@NotNull String __typename, @NotNull String name, @NotNull List<Version> versions) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.versions = (List)Utils.checkNotNull(versions, (Object)"versions == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public List<Version> versions() {
            return this.versions;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeList($responseFields[2], versions, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Version)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Image{__typename=" + this.__typename + ", name=" + this.name + ", versions=" + this.versions + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Image) {
                Image that = (Image)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.versions.equals(that.versions);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.versions.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Image> {
            final Version.Mapper versionFieldMapper = new Version.Mapper();

            public Image map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                List versions = reader.readList($responseFields[2], (ResponseReader.ListReader)new ResponseReader.ListReader<Version>(){

                    public Version read(ResponseReader.ListItemReader listItemReader) {
                        return (Version)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Version>(){

                            public Version read(ResponseReader reader) {
                                return versionFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Image(__typename, name, versions);
            }
        }
    }

    public static class Color {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"name", (String)"name", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"red", (String)"red", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"green", (String)"green", null, (boolean)false, Collections.emptyList()), ResponseField.forInt((String)"blue", (String)"blue", null, (boolean)false, Collections.emptyList()), ResponseField.forDouble((String)"alpha", (String)"alpha", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String name;
        final int red;
        final int green;
        final int blue;
        final double alpha;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Color(@NotNull String __typename, @NotNull String name, int red, int green, int blue, double alpha) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.name = (String)Utils.checkNotNull((Object)name, (Object)"name == null");
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        public int red() {
            return this.red;
        }

        public int green() {
            return this.green;
        }

        public int blue() {
            return this.blue;
        }

        public double alpha() {
            return this.alpha;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], name);
                    writer.writeInt($responseFields[2], Integer.valueOf(red));
                    writer.writeInt($responseFields[3], Integer.valueOf(green));
                    writer.writeInt($responseFields[4], Integer.valueOf(blue));
                    writer.writeDouble($responseFields[5], Double.valueOf(alpha));
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Color{__typename=" + this.__typename + ", name=" + this.name + ", red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Color) {
                Color that = (Color)o;
                return this.__typename.equals(that.__typename) && this.name.equals(that.name) && this.red == that.red && this.green == that.green && this.blue == that.blue && Double.doubleToLongBits(this.alpha) == Double.doubleToLongBits(that.alpha);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.name.hashCode();
                h *= 1000003;
                h ^= this.red;
                h *= 1000003;
                h ^= this.green;
                h *= 1000003;
                h ^= this.blue;
                h *= 1000003;
                this.$hashCode = h ^= Double.valueOf(this.alpha).hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Color> {
            public Color map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String name = reader.readString($responseFields[1]);
                int red = reader.readInt($responseFields[2]);
                int green = reader.readInt($responseFields[3]);
                int blue = reader.readInt($responseFields[4]);
                double alpha = reader.readDouble($responseFields[5]);
                return new Color(__typename, name, red, green, blue, alpha);
            }
        }
    }

    public static class Component {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"title", (String)"title", null, (boolean)false, Collections.emptyList()), ResponseField.forString((String)"vml", (String)"vml", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final String title;
        @NotNull
        final String vml;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Component(@NotNull String __typename, @NotNull String title, @NotNull String vml) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.title = (String)Utils.checkNotNull((Object)title, (Object)"title == null");
            this.vml = (String)Utils.checkNotNull((Object)vml, (Object)"vml == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public String title() {
            return this.title;
        }

        @NotNull
        public String vml() {
            return this.vml;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeString($responseFields[1], title);
                    writer.writeString($responseFields[2], vml);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Component{__typename=" + this.__typename + ", title=" + this.title + ", vml=" + this.vml + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Component) {
                Component that = (Component)o;
                return this.__typename.equals(that.__typename) && this.title.equals(that.title) && this.vml.equals(that.vml);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.title.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.vml.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Component> {
            public Component map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                String title = reader.readString($responseFields[1]);
                String vml = reader.readString($responseFields[2]);
                return new Component(__typename, title, vml);
            }
        }
    }

    public static class ReleaseInfo {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"components", (String)"components", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"colors", (String)"colors", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"images", (String)"images", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"appStrings", (String)"appStrings", null, (boolean)false, Collections.emptyList()), ResponseField.forList((String)"textStyles", (String)"textStyles", null, (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final List<Component> components;
        @NotNull
        final List<Color> colors;
        @NotNull
        final List<Image> images;
        @NotNull
        final List<AppString> appStrings;
        @NotNull
        final List<TextStyle> textStyles;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public ReleaseInfo(@NotNull String __typename, @NotNull List<Component> components, @NotNull List<Color> colors, @NotNull List<Image> images, @NotNull List<AppString> appStrings, @NotNull List<TextStyle> textStyles) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.components = (List)Utils.checkNotNull(components, (Object)"components == null");
            this.colors = (List)Utils.checkNotNull(colors, (Object)"colors == null");
            this.images = (List)Utils.checkNotNull(images, (Object)"images == null");
            this.appStrings = (List)Utils.checkNotNull(appStrings, (Object)"appStrings == null");
            this.textStyles = (List)Utils.checkNotNull(textStyles, (Object)"textStyles == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public List<Component> components() {
            return this.components;
        }

        @NotNull
        public List<Color> colors() {
            return this.colors;
        }

        @NotNull
        public List<Image> images() {
            return this.images;
        }

        @NotNull
        public List<AppString> appStrings() {
            return this.appStrings;
        }

        @NotNull
        public List<TextStyle> textStyles() {
            return this.textStyles;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeList($responseFields[1], components, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Component)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[2], colors, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Color)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[3], images, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((Image)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[4], appStrings, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((AppString)item).marshaller());
                            }
                        }
                    });
                    writer.writeList($responseFields[5], textStyles, new ResponseWriter.ListWriter(){

                        public void write(List items, ResponseWriter.ListItemWriter listItemWriter) {
                            for (Object item : items) {
                                listItemWriter.writeObject(((TextStyle)item).marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "ReleaseInfo{__typename=" + this.__typename + ", components=" + this.components + ", colors=" + this.colors + ", images=" + this.images + ", appStrings=" + this.appStrings + ", textStyles=" + this.textStyles + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ReleaseInfo) {
                ReleaseInfo that = (ReleaseInfo)o;
                return this.__typename.equals(that.__typename) && this.components.equals(that.components) && this.colors.equals(that.colors) && this.images.equals(that.images) && this.appStrings.equals(that.appStrings) && this.textStyles.equals(that.textStyles);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                h ^= this.components.hashCode();
                h *= 1000003;
                h ^= this.colors.hashCode();
                h *= 1000003;
                h ^= this.images.hashCode();
                h *= 1000003;
                h ^= this.appStrings.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.textStyles.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<ReleaseInfo> {
            final Component.Mapper componentFieldMapper = new Component.Mapper();
            final Color.Mapper colorFieldMapper = new Color.Mapper();
            final Image.Mapper imageFieldMapper = new Image.Mapper();
            final AppString.Mapper appStringFieldMapper = new AppString.Mapper();
            final TextStyle.Mapper textStyleFieldMapper = new TextStyle.Mapper();

            public ReleaseInfo map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                List components = reader.readList($responseFields[1], (ResponseReader.ListReader)new ResponseReader.ListReader<Component>(){

                    public Component read(ResponseReader.ListItemReader listItemReader) {
                        return (Component)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Component>(){

                            public Component read(ResponseReader reader) {
                                return componentFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List colors = reader.readList($responseFields[2], (ResponseReader.ListReader)new ResponseReader.ListReader<Color>(){

                    public Color read(ResponseReader.ListItemReader listItemReader) {
                        return (Color)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Color>(){

                            public Color read(ResponseReader reader) {
                                return colorFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List images = reader.readList($responseFields[3], (ResponseReader.ListReader)new ResponseReader.ListReader<Image>(){

                    public Image read(ResponseReader.ListItemReader listItemReader) {
                        return (Image)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Image>(){

                            public Image read(ResponseReader reader) {
                                return imageFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List appStrings = reader.readList($responseFields[4], (ResponseReader.ListReader)new ResponseReader.ListReader<AppString>(){

                    public AppString read(ResponseReader.ListItemReader listItemReader) {
                        return (AppString)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<AppString>(){

                            public AppString read(ResponseReader reader) {
                                return appStringFieldMapper.map(reader);
                            }
                        });
                    }
                });
                List textStyles = reader.readList($responseFields[5], (ResponseReader.ListReader)new ResponseReader.ListReader<TextStyle>(){

                    public TextStyle read(ResponseReader.ListItemReader listItemReader) {
                        return (TextStyle)listItemReader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<TextStyle>(){

                            public TextStyle read(ResponseReader reader) {
                                return textStyleFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new ReleaseInfo(__typename, components, colors, images, appStrings, textStyles);
            }
        }
    }

    public static class Team {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"__typename", (String)"__typename", null, (boolean)false, Collections.emptyList()), ResponseField.forObject((String)"releaseInfo", (String)"releaseInfo", (Map)new UnmodifiableMapBuilder(1).put((Object)"version", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"version").build()).build(), (boolean)false, Collections.emptyList())};
        @NotNull
        final String __typename;
        @NotNull
        final ReleaseInfo releaseInfo;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Team(@NotNull String __typename, @NotNull ReleaseInfo releaseInfo) {
            this.__typename = (String)Utils.checkNotNull((Object)__typename, (Object)"__typename == null");
            this.releaseInfo = (ReleaseInfo)Utils.checkNotNull((Object)releaseInfo, (Object)"releaseInfo == null");
        }

        @NotNull
        public String __typename() {
            return this.__typename;
        }

        @NotNull
        public ReleaseInfo releaseInfo() {
            return this.releaseInfo;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], __typename);
                    writer.writeObject($responseFields[1], releaseInfo.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Team{__typename=" + this.__typename + ", releaseInfo=" + this.releaseInfo + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Team) {
                Team that = (Team)o;
                return this.__typename.equals(that.__typename) && this.releaseInfo.equals(that.releaseInfo);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.__typename.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.releaseInfo.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Team> {
            final ReleaseInfo.Mapper releaseInfoFieldMapper = new ReleaseInfo.Mapper();

            public Team map(ResponseReader reader) {
                String __typename = reader.readString($responseFields[0]);
                ReleaseInfo releaseInfo = (ReleaseInfo)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<ReleaseInfo>(){

                    public ReleaseInfo read(ResponseReader reader) {
                        return releaseInfoFieldMapper.map(reader);
                    }
                });
                return new Team(__typename, releaseInfo);
            }
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObject((String)"team", (String)"team", (Map)new UnmodifiableMapBuilder(1).put((Object)"apiToken", (Object)new UnmodifiableMapBuilder(2).put((Object)"kind", (Object)"Variable").put((Object)"variableName", (Object)"apiToken").build()).build(), (boolean)false, Collections.emptyList())};
        @NotNull
        final Team team;
        private volatile transient String $toString;
        private volatile transient int $hashCode;
        private volatile transient boolean $hashCodeMemoized;

        public Data(@NotNull Team team) {
            this.team = (Team)Utils.checkNotNull((Object)team, (Object)"team == null");
        }

        @NotNull
        public Team team() {
            return this.team;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeObject($responseFields[0], team.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{team=" + this.team + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.team.equals(that.team);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.team.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Team.Mapper teamFieldMapper = new Team.Mapper();

            public Data map(ResponseReader reader) {
                Team team = (Team)reader.readObject($responseFields[0], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Team>(){

                    public Team read(ResponseReader reader) {
                        return teamFieldMapper.map(reader);
                    }
                });
                return new Data(team);
            }
        }
    }

    public static final class Variables
    extends Operation.Variables {
        @NotNull
        private final String apiToken;
        @NotNull
        private final String version;
        private final Input<Platform> platform;
        private final transient Map<String, Object> valueMap = new LinkedHashMap<String, Object>();

        Variables(@NotNull String apiToken, @NotNull String version, Input<Platform> platform) {
            this.apiToken = apiToken;
            this.version = version;
            this.platform = platform;
            this.valueMap.put("apiToken", apiToken);
            this.valueMap.put("version", version);
            if (platform.defined) {
                this.valueMap.put("platform", platform.value);
            }
        }

        @NotNull
        public String apiToken() {
            return this.apiToken;
        }

        @NotNull
        public String version() {
            return this.version;
        }

        public Input<Platform> platform() {
            return this.platform;
        }

        public Map<String, Object> valueMap() {
            return Collections.unmodifiableMap(this.valueMap);
        }

        public InputFieldMarshaller marshaller() {
            return new InputFieldMarshaller(){

                public void marshal(InputFieldWriter writer) throws IOException {
                    writer.writeString("apiToken", apiToken);
                    writer.writeString("version", version);
                    if (((Variables)this).platform.defined) {
                        writer.writeString("platform", ((Variables)this).platform.value != null ? ((Platform)((Object)((Variables)this).platform.value)).rawValue() : null);
                    }
                }
            };
        }
    }

    public static final class Builder {
        @NotNull
        private String apiToken;
        @NotNull
        private String version;
        private Input<Platform> platform = Input.absent();

        Builder() {
        }

        public Builder apiToken(@NotNull String apiToken) {
            this.apiToken = apiToken;
            return this;
        }

        public Builder version(@NotNull String version) {
            this.version = version;
            return this;
        }

        public Builder platform(@Nullable Platform platform) {
            this.platform = Input.fromNullable((Object)((Object)platform));
            return this;
        }

        public Builder platformInput(@NotNull Input<Platform> platform) {
            this.platform = (Input)Utils.checkNotNull(platform, (Object)"platform == null");
            return this;
        }

        public AssetsQuery build() {
            Utils.checkNotNull((Object)this.apiToken, (Object)"apiToken == null");
            Utils.checkNotNull((Object)this.version, (Object)"version == null");
            return new AssetsQuery(this.apiToken, this.version, this.platform);
        }
    }
}

