/*
 * Decompiled with CFR 0.152.
 */
package app.visly.filesystem;

import app.visly.filesystem.FilePath;
import app.visly.filesystem.FileSystem;
import app.visly.filesystem.FileSystemError;
import app.visly.filesystem.SystemUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\b\u0010\b\u001a\u00020\u0003H\u0002\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\f\u001a\u00020\u0003*\u00020\n\u00a8\u0006\r"}, d2={"assertMatches", "", "path", "", "pattern", "assertValidFileSystem", "fileSystem", "Lapp/visly/filesystem/FileSystem;", "projectRootDir", "homeDir", "Lapp/visly/filesystem/FileSystem$Companion;", "outputDir", "projectDir", "visly-gradle-plugin"})
public final class FileSystemKt {
    private static final void assertMatches(String path, String pattern) {
        if (!new Regex(pattern).matches((CharSequence)path)) {
            throw (Throwable)new FileSystemError("Path " + path + " is not valid for file system");
        }
    }

    private static final void assertValidFileSystem(FileSystem fileSystem) {
        FileSystemKt.assertMatches(fileSystem.path(FilePath.OUTPUT_DIR), "^/.*/src/visly/gen");
        FileSystemKt.assertMatches(fileSystem.path(FilePath.PROJECT_DIR), "^.*/VislyAndroid");
        FileSystemKt.assertMatches(fileSystem.path(FilePath.HOME_DIR), "^/.*/.visly");
    }

    private static final String projectRootDir() {
        String appId = StringsKt.replace$default((String)SystemUtil.INSTANCE.currentDir(), (String)"/", (String)"_", (boolean)false, (int)4, null);
        return SystemUtil.INSTANCE.tempDir() + "/app.visly/" + appId + "/VislyAndroid";
    }

    @NotNull
    public static final String projectDir(@NotNull FileSystem.Companion $this$projectDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$projectDir, (String)"$this$projectDir");
        return FileSystem.Companion.getInstance().path(FilePath.PROJECT_DIR);
    }

    @NotNull
    public static final String outputDir(@NotNull FileSystem.Companion $this$outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$outputDir, (String)"$this$outputDir");
        return FileSystem.Companion.getInstance().path(FilePath.OUTPUT_DIR);
    }

    @NotNull
    public static final String homeDir(@NotNull FileSystem.Companion $this$homeDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$homeDir, (String)"$this$homeDir");
        return FileSystem.Companion.getInstance().path(FilePath.HOME_DIR);
    }

    public static final /* synthetic */ void access$assertValidFileSystem(FileSystem fileSystem) {
        FileSystemKt.assertValidFileSystem(fileSystem);
    }

    public static final /* synthetic */ String access$projectRootDir() {
        return FileSystemKt.projectRootDir();
    }
}

