/*
 * Decompiled with CFR 0.152.
 */
package app.visly.codegen.textstyle;

import app.visly.CodegenError;
import app.visly.codegen.AssetGenerator;
import app.visly.codegen.util.FileDownloader;
import app.visly.codegen.util.StringUtilKt;
import app.visly.codegen.util.VMLDimensionKt;
import app.visly.filesystem.FileSystem_UtilKt;
import app.visly.io.AssetsQuery;
import com.commit451.resourcespoet.ResourcesPoet;
import com.commit451.resourcespoet.StyleItem;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0014\u0010\r\u001a\u00020\b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/visly/codegen/textstyle/TextStylesGenerator;", "Lapp/visly/codegen/AssetGenerator;", "resDir", "", "downloader", "Lapp/visly/codegen/util/FileDownloader;", "(Ljava/lang/String;Lapp/visly/codegen/util/FileDownloader;)V", "createFile", "", "data", "", "name", "extension", "generateAssets", "release", "Lapp/visly/io/AssetsQuery$ReleaseInfo;", "Lapp/visly/codegen/Release;", "generateTextStyle", "style", "Lapp/visly/io/AssetsQuery$TextStyle;", "resPoet", "Lcom/commit451/resourcespoet/ResourcesPoet;", "visly-gradle-plugin"})
public final class TextStylesGenerator
implements AssetGenerator {
    private final String resDir;
    private final FileDownloader downloader;

    @Override
    public void generateAssets(@NotNull AssetsQuery.ReleaseInfo release) {
        Intrinsics.checkParameterIsNotNull((Object)release, (String)"release");
        FileSystem_UtilKt.VislyFS().mkdirs(this.resDir + "/font");
        FileSystem_UtilKt.VislyFS().mkdirs(this.resDir + "/styles");
        ResourcesPoet resPoet = ResourcesPoet.Companion.create(true);
        List<AssetsQuery.TextStyle> list = release.textStyles();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"release.textStyles()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AssetsQuery.TextStyle it = (AssetsQuery.TextStyle)element$iv;
            boolean bl = false;
            AssetsQuery.TextStyle textStyle = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)textStyle, (String)"it");
            this.generateTextStyle(textStyle, resPoet);
        }
        String string = resPoet.build();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] xml = byArray;
        FileSystem_UtilKt.VislyFS().writeBytes(xml, this.resDir + "/values/styles.xml");
    }

    private final void generateTextStyle(AssetsQuery.TextStyle style, ResourcesPoet resPoet) {
        StringBuilder stringBuilder = new StringBuilder().append("visly_");
        String string = style.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"style.name()");
        String name = stringBuilder.append(StringUtilKt.toValidResourceName(string)).toString();
        AssetsQuery.Font font = style.font();
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"style.font()");
        AssetsQuery.Font font2 = font;
        StringBuilder stringBuilder2 = new StringBuilder().append("visly_");
        String string2 = font2.family();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"font.family()");
        StringBuilder stringBuilder3 = stringBuilder2.append(StringUtilKt.toValidResourceName(string2)).append('_');
        String string3 = font2.fontWeight();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"font.fontWeight()");
        String string4 = font2.fontStyle().toString();
        StringBuilder stringBuilder4 = stringBuilder3.append(StringUtilKt.toValidResourceName(string3)).append('_');
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        String string7 = string6;
        String fontName = stringBuilder4.append(StringUtilKt.toValidResourceName(string7)).toString();
        List items = CollectionsKt.listOf((Object[])new StyleItem[]{new StyleItem("android:fontFamily", "@font/" + fontName), new StyleItem("android:textSize", VMLDimensionKt.xmlFormatted(VMLDimensionKt.vmlPx(style.fontSize().value()).getDp()) + "sp"), new StyleItem("android:lineSpacingMultiplier", "0"), new StyleItem("android:lineSpacingExtra", VMLDimensionKt.xmlFormatted(VMLDimensionKt.vmlPx(style.lineHeight().value()).getDp()) + "dp")});
        byte[] files = null;
        try {
            String string8 = font2.fileUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"font.fileUrl()");
            files = this.downloader.download(string8);
        }
        catch (Throwable error) {
            throw (Throwable)CodegenError.INSTANCE.textStylesError("Failed to download font: " + font2.fileUrl() + ". " + error.getMessage(), "Failed to download font: " + font2.fileUrl());
        }
        String string9 = font2.fileExtension();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"font.fileExtension()");
        this.createFile(files, fontName, string9);
        resPoet.addStyle(name, "TextAppearance.AppCompat", items);
    }

    private final void createFile(byte[] data, String name, String extension) {
        FileSystem_UtilKt.VislyFS().writeBytes(data, this.resDir + "/font/" + name + '.' + extension);
    }

    public TextStylesGenerator(@NotNull String resDir, @NotNull FileDownloader downloader) {
        Intrinsics.checkParameterIsNotNull((Object)resDir, (String)"resDir");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        this.resDir = resDir;
        this.downloader = downloader;
    }
}

