package app.visly.version

import app.visly.io.Client

class VersionChecker(
    private val client: Client,
    private val currentVersion: String,
    private val checkIntervalInMillis: Long,
    lastCheckFile: String,
    private val lastCheck: LastCheck = LastCheck(lastCheckFile)
) {

    fun shouldCheckNewVersion(): Boolean {
        return System.currentTimeMillis() - lastCheck.getLastCheckInMillis() > checkIntervalInMillis
    }

    fun checkNewVersion(): String? {
        try {
            val latestVersion = client.fetchLatestVersion()
            if (latestVersion.compareTo(currentVersion) > 0) {
                return latestVersion
            } else {
                return null
            }
        } finally {
            lastCheck.setLastCheckInMillis(System.currentTimeMillis())
        }
    }
}