package app.visly.version

import app.visly.filesystem.VislyFS
import java.io.File

class LastCheck(private val file: String) {

    fun getLastCheckInMillis(): Long {
        if (VislyFS().exists(file)) {
            val lastCheckInMillisString = VislyFS()
                .readText(
                    file,
                    charset("utf8")
                )
            return lastCheckInMillisString.toLongOrNull()?.let { it } ?: 0
        }
        return 0
    }

    fun setLastCheckInMillis(time: Long) {

        val parentDir = File(file).parent
        if (VislyFS().exists(parentDir).not()) {
            VislyFS().mkdirs(parentDir)
        }

        VislyFS().writeText(
            text = "$time",
            charset = charset("utf8"),
            path = file
        )
    }
}