package app.visly.project

import app.visly.VislyLog
import app.visly.filesystem.VislyFS

class ProjectInstaller(
    private val projectResDir: String,
    private val outputDir: String,
    private val outputResDir: String
) {

    fun install() {
        VislyLog.d("Copying resources\n from: $projectResDir\nto: $outputResDir")
        VislyFS().deleteRecursively(outputDir)
        VislyFS().copy(
            fromPath = projectResDir,
            toPath = outputResDir
        )
    }
}