package app.visly.mixpanel

import app.visly.VislyLog
import app.visly.filesystem.VislyFS
import java.io.File
import java.util.*

class User(private val userFile: String) {

    val userId: String get() {
        return readId()?.let { it }
                ?: generateAndStoreId()
    }

    fun generateAndStoreId(): String {
        val id = UUID.randomUUID().toString()
        storeId(id)
        return id
    }

    fun readId(): String? {
        if (VislyFS().exists(userFile)) {
            val id = VislyFS().readText(userFile, charset("utf8"))
            if (!id.isEmpty()) {
                return id
            } else {
                VislyLog.d("Could not read user file: $userFile")
            }
        }
        return null
    }

    fun storeId(id: String) {
        val parent = File(userFile).parent
        if (!VislyFS().exists(parent)) {
            VislyFS().mkdirs(parent)
        }

        VislyFS().writeText(id, userFile, charset("utf8"))
    }
}