package app.visly.mixpanel

import app.visly.VislyLog
import com.mixpanel.mixpanelapi.MixpanelAPI
import org.json.JSONObject

class MixpanelUploader(private val mixpanel: MixpanelAPI = MixpanelAPI()) {

    fun send(message: JSONObject) {
        VislyLog.d("Uploading to mix panel: $message")
        Thread(Runnable {
            mixpanel.sendMessage(message)
        }).start()
    }
}