package app.visly.mixpanel

import app.visly.Config
import app.visly.VislyError
import com.mixpanel.mixpanelapi.MessageBuilder
import org.apache.commons.lang3.SystemUtils
import org.json.JSONObject

class Mixpanel(
    private val token: String = Config.MIXPANEL_TOKEN,
    private val deviceId: String,
    private val osVersion: String = "${SystemUtils.OS_NAME}-${SystemUtils.OS_VERSION}",
    private val toolVersion: String = Config.VERSION,
    private val uploader: MixpanelUploader = MixpanelUploader()
) {

    fun track(error: VislyError) {
        uploader.send(
            createEvent(
                "Error",
                JSONObject()
                    .put("category", error.errorCategory)
                    .put("cause", error.errorCause)
                    .put("description", error.errorDescription)
            )
        )
    }

    fun track(event: String) {
        uploader.send(
            createEvent(event)
        )
    }

    private fun createEvent(event: String, props: JSONObject = JSONObject()): JSONObject {
        val completeProps = props
            .put("os", osVersion)
            .put("tool_version", toolVersion)

        val messageBuilder = MessageBuilder(token)
        return messageBuilder.event(deviceId, event, completeProps)
    }
}