package app.visly.gradle

import app.visly.*
import app.visly.filesystem.*
import app.visly.mixpanel.Mixpanel
import app.visly.mixpanel.User
import com.android.build.gradle.AppExtension
import com.android.build.gradle.AppPlugin
import org.gradle.api.Plugin
import org.gradle.api.Project

class VislyPlugin : Plugin<Project> {

    override fun apply(project: Project) {

        project.extensions.create("visly", VislyPluginExtension::class.java)

        project.plugins.all {
            when (it) {
                is AppPlugin -> {
                    project.extensions.findByType(AppExtension::class.java)?.run {
                        registerTask(project = project, appExtension = this)
                    }
                }
            }
        }
    }

    private fun registerTask(project: Project, appExtension: AppExtension) {

        FileSystem.setup(project.projectDir.absolutePath)

        VislyLog.d(VislyFS().toString())

        val user = User(
            "${FileSystem.homeDir()}/${Config.USER_FILE}"
        )

        val mixPanel = Mixpanel(
            deviceId = user.userId
        )

        val config = VislyConfiguration(
            projectDir = FileSystem.projectDir(),
            outputDir = FileSystem.outputDir(),
            versionLastCheckFile = "${FileSystem.homeDir()}/gradle-plugin/last-version-check",
            versionCheckIntervalInMillis = 1000*60*60*3 // 3 hours
        )

        val visly = VislyImpl(
            config = config,
            logger = GradleLogger(
                project.logger,
                mixPanel
            )
        )

        // Version check
        val checkNewVersion = project.tasks.create("checkNewVislyVersion", CheckVersionTask::class.java)
        checkNewVersion.visly = VislyWrapper(visly)

        // Install
        val installTask = project.tasks.create("installVisly", InstallTask::class.java)
        installTask.visly = VislyWrapper(visly)
        installTask.dependsOn(checkNewVersion)

        appExtension.applicationVariants.all {
            it.registerGeneratedResFolders(project.files(config.outputResDir))
        }
    }
}