package app.visly.gradle

import app.visly.Config
import app.visly.ConfigurationError
import app.visly.VislyWrapper
import org.gradle.api.DefaultTask
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.TaskAction

open class InstallTask : DefaultTask() {

    var visly: VislyWrapper? = null

    val conf = VislyPluginExtension.get(project)

    @Input
    fun version(): String {
        return conf.version?.let { it } ?: "latest"
    }

    @Input
    fun apiKey(): String {
        return conf.apiKey?.let { it }
            ?: System.getenv("VISLY_API_KEY")?.let { it }
            ?: throw ConfigurationError.noApiKey(
                "No api key provided",
                "No api key provided. Make sure apiKey is configured in build.gradle."
            )
    }

    @Input
    fun serverUrl(): String {
        return conf.serverUrl?.takeIf { Config.DEBUG }?.let { it } ?: Config.SERVER_URL
    }

    @TaskAction
    fun install() {
        visly?.install(apiKey(), version(), serverUrl())
    }
}