package app.visly.gradle

import app.visly.Config
import app.visly.Logger
import app.visly.VislyError
import app.visly.mixpanel.Mixpanel
import org.gradle.api.logging.LogLevel

class GradleLogger(
    private val logger: org.gradle.api.logging.Logger,
    private val mixpanel: Mixpanel
) : Logger {

    override fun lc(message: String) {
        logger.log(LogLevel.LIFECYCLE, message)
    }

    override fun i(message: String) {
        logger.log(LogLevel.LIFECYCLE, message)
    }

    override fun d(message: String) {
        val level = if (Config.DEBUG) LogLevel.LIFECYCLE else LogLevel.DEBUG
        logger.log(level, message)
    }

    override fun w(message: String) {
        logger.log(LogLevel.WARN, message)
    }

    override fun e(message: String) {
        logger.log(LogLevel.ERROR, message)
    }

    override fun track(event: String) {
        mixpanel.track(event)
    }

    override fun track(error: VislyError) {
        mixpanel.track(error)
    }
}